/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.multimap;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class ClientMultiMapListenerStressTest {
    private static final int MAX_SECONDS = 600;
    private static final int NUMBER_OF_CLIENTS = 8;
    private static final int THREADS_PER_CLIENT = 4;
    private static final String MAP_NAME = HazelcastTestSupport.randomString();
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        Config cfg = new Config();
        cfg.setProperty("hazelcast.event.queue.capacity", "5000000");
        this.server = this.hazelcastFactory.newHazelcastInstance(cfg);
    }

    @Test
    public void listenerAddStressTest() throws InterruptedException {
        int i;
        Thread[] putThreads = new PutItemsThread[32];
        int idx = 0;
        for (i = 0; i < 8; ++i) {
            HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
            for (int j = 0; j < 4; ++j) {
                PutItemsThread t = new PutItemsThread(client);
                putThreads[idx++] = t;
            }
        }
        for (i = 0; i < putThreads.length; ++i) {
            putThreads[i].start();
        }
        MultiMap multiMap = this.server.getMultiMap(MAP_NAME);
        HazelcastTestSupport.assertJoinable((long)600L, (Thread[])putThreads);
        int expectedSize = 100 * putThreads.length;
        Assert.assertEquals((long)expectedSize, (long)multiMap.size());
        this.assertReceivedEventsSize(expectedSize, (PutItemsThread[])putThreads);
    }

    private void assertReceivedEventsSize(int expectedSize, PutItemsThread[] putThreads) {
        for (int i = 0; i < putThreads.length; ++i) {
            putThreads[i].assertResult(expectedSize);
        }
    }

    static class MyEntryListener
    extends EntryAdapter {
        public AtomicInteger add = new AtomicInteger(0);

        MyEntryListener() {
        }

        public void entryAdded(EntryEvent event) {
            this.add.incrementAndGet();
        }
    }

    public class PutItemsThread
    extends Thread {
        public static final int MAX_ITEMS = 100;
        public final MyEntryListener listener = new MyEntryListener();
        public HazelcastInstance client;
        public MultiMap mm;
        public String id = HazelcastTestSupport.randomString();

        public PutItemsThread(HazelcastInstance client) {
            this.client = client;
            this.mm = client.getMultiMap(MAP_NAME);
            this.mm.addEntryListener((EntryListener)this.listener, true);
        }

        @Override
        public void run() {
            for (int i = 0; i < 100; ++i) {
                this.mm.put((Object)(this.id + i), (Object)(this.id + i));
            }
        }

        public void assertResult(final int target) {
            HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertEquals((long)target, (long)PutItemsThread.this.listener.add.get());
                }
            });
        }
    }
}

