/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.partitionservice;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.partition.PartitionLostEvent;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.partition.PartitionLostListenerStressTest;
import com.hazelcast.spi.impl.PortablePartitionLostEvent;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.partition.IPartitionLostEvent;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientPartitionLostListenerTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void test_partitionLostListener_registered() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        client.getPartitionService().addPartitionLostListener((PartitionLostListener)Mockito.mock(PartitionLostListener.class));
        this.assertRegistrationsSizeEventually(instance, 2);
    }

    @Test
    public void test_partitionLostListener_removed() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        String registrationId = client.getPartitionService().addPartitionLostListener((PartitionLostListener)Mockito.mock(PartitionLostListener.class));
        this.assertRegistrationsSizeEventually(instance, 2);
        client.getPartitionService().removePartitionLostListener(registrationId);
        this.assertRegistrationsSizeEventually(instance, 1);
    }

    @Test
    public void test_partitionLostListener_invoked() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{instance, client});
        PartitionLostListenerStressTest.EventCollectingPartitionLostListener listener = new PartitionLostListenerStressTest.EventCollectingPartitionLostListener();
        client.getPartitionService().addPartitionLostListener((PartitionLostListener)listener);
        this.assertRegistrationsSizeEventually(instance, 2);
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)HazelcastTestSupport.getNode((HazelcastInstance)instance).getNodeEngine().getService("hz:core:partitionService");
        int partitionId = 5;
        partitionService.onPartitionLost(new IPartitionLostEvent(5, 0, null));
        this.assertPartitionLostEventEventually(listener, 5);
    }

    @Test
    public void test_partitionLostListener_invoked_fromOtherNode() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(false);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{instance1, instance2, client});
        HazelcastClientInstanceImpl clientInstanceImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        Address clientOwnerAddress = clientInstanceImpl.getConnectionManager().getOwnerConnectionAddress();
        HazelcastInstance other = HazelcastTestSupport.getAddress((HazelcastInstance)instance1).equals((Object)clientOwnerAddress) ? instance2 : instance1;
        PartitionLostListenerStressTest.EventCollectingPartitionLostListener listener = new PartitionLostListenerStressTest.EventCollectingPartitionLostListener();
        client.getPartitionService().addPartitionLostListener((PartitionLostListener)listener);
        this.assertRegistrationsSizeEventually(instance1, 3);
        this.assertRegistrationsSizeEventually(instance2, 3);
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)HazelcastTestSupport.getNode((HazelcastInstance)other).getNodeEngine().getService("hz:core:partitionService");
        int partitionId = 5;
        partitionService.onPartitionLost(new IPartitionLostEvent(5, 0, null));
        this.assertPartitionLostEventEventually(listener, 5);
    }

    private void assertRegistrationsSizeEventually(final HazelcastInstance instance, final int size) {
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                InternalEventService eventService = HazelcastTestSupport.getNode((HazelcastInstance)instance).getNodeEngine().getEventService();
                Collection registrations = eventService.getRegistrations("hz:core:partitionService", ".partitionLost");
                Assert.assertEquals((long)size, (long)registrations.size());
            }
        });
    }

    private void assertPartitionLostEventEventually(final PartitionLostListenerStressTest.EventCollectingPartitionLostListener listener, final int partitionId) {
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                List events = listener.getEvents();
                Assert.assertFalse((boolean)events.isEmpty());
                Assert.assertEquals((long)partitionId, (long)((PartitionLostEvent)events.get(0)).getPartitionId());
            }
        });
    }

    @Test
    public void test_portableMapPartitionLostEvent_serialization() throws IOException {
        Address source = new Address();
        PortablePartitionLostEvent event = new PortablePartitionLostEvent(1, 2, source);
        PortableWriter writer = (PortableWriter)Mockito.mock(PortableWriter.class);
        ObjectDataOutput output = (ObjectDataOutput)Mockito.mock(ObjectDataOutput.class);
        Mockito.when((Object)writer.getRawDataOutput()).thenReturn((Object)output);
        event.writePortable(writer);
        ((PortableWriter)Mockito.verify((Object)writer)).writeInt("p", 1);
        ((PortableWriter)Mockito.verify((Object)writer)).writeInt("l", 2);
        ((ObjectDataOutput)Mockito.verify((Object)output)).writeObject((Object)source);
    }

    @Test
    public void test_portableMapPartitionLostEvent_deserialization() throws IOException {
        Address source = new Address();
        PortablePartitionLostEvent event = new PortablePartitionLostEvent();
        PortableReader reader = (PortableReader)Mockito.mock(PortableReader.class);
        ObjectDataInput input = (ObjectDataInput)Mockito.mock(ObjectDataInput.class);
        Mockito.when((Object)reader.getRawDataInput()).thenReturn((Object)input);
        Mockito.when((Object)reader.readInt("p")).thenReturn((Object)1);
        Mockito.when((Object)reader.readInt("l")).thenReturn((Object)2);
        Mockito.when((Object)input.readObject()).thenReturn((Object)source);
        event.readPortable(reader);
        Assert.assertEquals((long)1L, (long)event.getPartitionId());
        Assert.assertEquals((long)2L, (long)event.getLostBackupCount());
        Assert.assertEquals((Object)source, (Object)event.getSource());
    }
}

