/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.pncounter;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.crdt.pncounter.BasePNCounterBasicIntegrationTest;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParallelParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientPNCounterBasicIntegrationTest
extends BasePNCounterBasicIntegrationTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance[] members;
    private HazelcastInstance[] clients;
    @Parameterized.Parameter
    public int replicaCount;

    @Parameterized.Parameters(name="replicaCount:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({1}, {2}, {Integer.MAX_VALUE});
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        PNCounterConfig counterConfig = new PNCounterConfig().setName("default").setReplicaCount(this.replicaCount).setStatisticsEnabled(true);
        Config config = new Config().setProperty(GroupProperty.PARTITION_COUNT.getName(), "5").setCRDTReplicationConfig(new CRDTReplicationConfig().setReplicationPeriodMillis(200).setMaxConcurrentReplicationTargets(Integer.MAX_VALUE)).addPNCounterConfig(counterConfig);
        this.members = this.hazelcastFactory.newInstances(config, 2);
        this.clients = new HazelcastInstance[]{this.hazelcastFactory.newHazelcastClient(), this.hazelcastFactory.newHazelcastClient()};
    }

    protected HazelcastInstance getInstance1() {
        return this.clients[0];
    }

    protected HazelcastInstance getInstance2() {
        return this.clients[1];
    }

    protected HazelcastInstance[] getMembers() {
        return this.members;
    }
}

