/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.pncounter;

import com.hazelcast.client.proxy.ClientPNCounterProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.crdt.pncounter.BasePNCounterConsistencyLostTest;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientPNCounterConsistencyLostTest
extends BasePNCounterConsistencyLostTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private String counterName = ClientPNCounterConsistencyLostTest.randomMapName((String)"counter-");
    private HazelcastInstance[] members;
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        Config config = new Config().setProperty(GroupProperty.PARTITION_COUNT.getName(), "5").setCRDTReplicationConfig(new CRDTReplicationConfig().setReplicationPeriodMillis(Integer.MAX_VALUE).setMaxConcurrentReplicationTargets(Integer.MAX_VALUE));
        this.members = this.hazelcastFactory.newInstances(config, 2);
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    protected HazelcastInstance[] getMembers() {
        return this.members;
    }

    protected Address getCurrentTargetReplicaAddress(PNCounter driver) {
        return ((ClientPNCounterProxy)driver).getCurrentTargetReplicaAddress();
    }

    protected void assertState(PNCounter driver) {
        Assert.assertEquals((long)5L, (long)driver.get());
    }

    protected void mutate(PNCounter driver) {
        driver.addAndGet(5L);
    }

    protected PNCounter getCounter() {
        return this.client.getPNCounter(this.counterName);
    }
}

