/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.ringbuffer;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.ringbuffer.impl.client.PortableReadResultSet;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class RingbufferTest
extends HazelcastTestSupport {
    public static final int CAPACITY = 10;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private HazelcastInstance server;
    private Ringbuffer<String> clientRingbuffer;
    private Ringbuffer<String> serverRingbuffer;

    @Before
    public void init() {
        Config config = new Config();
        config.addRingBufferConfig(new RingbufferConfig("rb*").setCapacity(10));
        this.server = this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient();
        String name = "rb-" + RingbufferTest.randomString();
        this.serverRingbuffer = this.server.getRingbuffer(name);
        this.clientRingbuffer = this.client.getRingbuffer(name);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void headSequence() {
        for (int k = 0; k < 20; ++k) {
            this.serverRingbuffer.add((Object)"foo");
        }
        Assert.assertEquals((long)this.serverRingbuffer.headSequence(), (long)this.clientRingbuffer.headSequence());
    }

    @Test
    public void tailSequence() {
        for (int k = 0; k < 20; ++k) {
            this.serverRingbuffer.add((Object)"foo");
        }
        Assert.assertEquals((long)this.serverRingbuffer.tailSequence(), (long)this.clientRingbuffer.tailSequence());
    }

    @Test
    public void size() {
        this.serverRingbuffer.add((Object)"foo");
        Assert.assertEquals((long)this.serverRingbuffer.size(), (long)this.clientRingbuffer.size());
    }

    @Test
    public void capacity() {
        Assert.assertEquals((long)this.serverRingbuffer.capacity(), (long)this.clientRingbuffer.capacity());
    }

    @Test
    public void remainingCapacity() {
        this.serverRingbuffer.add((Object)"foo");
        Assert.assertEquals((long)this.serverRingbuffer.remainingCapacity(), (long)this.clientRingbuffer.remainingCapacity());
    }

    @Test
    public void add() throws Exception {
        this.clientRingbuffer.add((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.serverRingbuffer.readOne(0L));
    }

    @Test
    public void addAsync() throws Exception {
        ICompletableFuture f = this.clientRingbuffer.addAsync((Object)"foo", OverflowPolicy.OVERWRITE);
        Long result = (Long)f.get();
        Assert.assertEquals((Object)new Long(this.serverRingbuffer.headSequence()), (Object)result);
        Assert.assertEquals((Object)"foo", (Object)this.serverRingbuffer.readOne(0L));
        Assert.assertEquals((long)0L, (long)this.serverRingbuffer.headSequence());
        Assert.assertEquals((long)0L, (long)this.serverRingbuffer.tailSequence());
    }

    @Test
    public void addAll() throws Exception {
        ICompletableFuture f = this.clientRingbuffer.addAllAsync(Arrays.asList("foo", "bar"), OverflowPolicy.OVERWRITE);
        Long result = (Long)f.get();
        Assert.assertEquals((Object)new Long(this.serverRingbuffer.tailSequence()), (Object)result);
        Assert.assertEquals((Object)"foo", (Object)this.serverRingbuffer.readOne(0L));
        Assert.assertEquals((Object)"bar", (Object)this.serverRingbuffer.readOne(1L));
        Assert.assertEquals((long)0L, (long)this.serverRingbuffer.headSequence());
        Assert.assertEquals((long)1L, (long)this.serverRingbuffer.tailSequence());
    }

    @Test
    public void readOne() throws Exception {
        this.serverRingbuffer.add((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.clientRingbuffer.readOne(0L));
    }

    @Test
    public void readManyAsync_noFilter() throws Exception {
        this.serverRingbuffer.add((Object)"1");
        this.serverRingbuffer.add((Object)"2");
        this.serverRingbuffer.add((Object)"3");
        ICompletableFuture f = this.clientRingbuffer.readManyAsync(0L, 3, 3, null);
        ReadResultSet rs = (ReadResultSet)f.get();
        RingbufferTest.assertInstanceOf(PortableReadResultSet.class, (Object)rs);
        Assert.assertEquals((long)3L, (long)rs.readCount());
        Assert.assertEquals((Object)"1", (Object)rs.get(0));
        Assert.assertEquals((Object)"2", (Object)rs.get(1));
        Assert.assertEquals((Object)"3", (Object)rs.get(2));
    }

    @Test
    public void readManyAsync_maxCount() throws Exception {
        this.serverRingbuffer.add((Object)"1");
        this.serverRingbuffer.add((Object)"2");
        this.serverRingbuffer.add((Object)"3");
        this.serverRingbuffer.add((Object)"4");
        this.serverRingbuffer.add((Object)"5");
        this.serverRingbuffer.add((Object)"6");
        ICompletableFuture f = this.clientRingbuffer.readManyAsync(0L, 3, 3, null);
        ReadResultSet rs = (ReadResultSet)f.get();
        RingbufferTest.assertInstanceOf(PortableReadResultSet.class, (Object)rs);
        Assert.assertEquals((long)3L, (long)rs.readCount());
        Assert.assertEquals((Object)"1", (Object)rs.get(0));
        Assert.assertEquals((Object)"2", (Object)rs.get(1));
        Assert.assertEquals((Object)"3", (Object)rs.get(2));
    }

    @Test
    public void readManyAsync_withFilter() throws Exception {
        this.serverRingbuffer.add((Object)"good1");
        this.serverRingbuffer.add((Object)"bad1");
        this.serverRingbuffer.add((Object)"good2");
        this.serverRingbuffer.add((Object)"bad2");
        this.serverRingbuffer.add((Object)"good3");
        this.serverRingbuffer.add((Object)"bad3");
        ICompletableFuture f = this.clientRingbuffer.readManyAsync(0L, 3, 3, (IFunction)new Filter());
        ReadResultSet rs = (ReadResultSet)f.get();
        RingbufferTest.assertInstanceOf(PortableReadResultSet.class, (Object)rs);
        Assert.assertEquals((long)5L, (long)rs.readCount());
        Assert.assertEquals((Object)"good1", (Object)rs.get(0));
        Assert.assertEquals((Object)"good2", (Object)rs.get(1));
        Assert.assertEquals((Object)"good3", (Object)rs.get(2));
    }

    @Test
    public void readManyAsync_withFilter_andMaxCount() throws Exception {
        this.serverRingbuffer.add((Object)"good1");
        this.serverRingbuffer.add((Object)"bad1");
        this.serverRingbuffer.add((Object)"good2");
        this.serverRingbuffer.add((Object)"bad2");
        this.serverRingbuffer.add((Object)"good3");
        this.serverRingbuffer.add((Object)"bad3");
        this.serverRingbuffer.add((Object)"good4");
        this.serverRingbuffer.add((Object)"bad4");
        ICompletableFuture f = this.clientRingbuffer.readManyAsync(0L, 3, 3, (IFunction)new Filter());
        ReadResultSet rs = (ReadResultSet)f.get();
        RingbufferTest.assertInstanceOf(PortableReadResultSet.class, (Object)rs);
        Assert.assertEquals((long)5L, (long)rs.readCount());
        Assert.assertEquals((Object)"good1", (Object)rs.get(0));
        Assert.assertEquals((Object)"good2", (Object)rs.get(1));
        Assert.assertEquals((Object)"good3", (Object)rs.get(2));
    }

    static class Filter
    implements IFunction<String, Boolean> {
        Filter() {
        }

        public Boolean apply(String input) {
            return input.startsWith("good");
        }
    }
}

