/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.scheduledexecutor;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.scheduledexecutor.ScheduledExecutorServiceBasicTest;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientScheduledExecutorServiceBasicTest
extends ScheduledExecutorServiceBasicTest {
    private TestHazelcastFactory factory;

    @After
    public void teardown() {
        if (this.factory != null) {
            this.factory.terminateAll();
        }
    }

    protected HazelcastInstance[] createClusterWithCount(int count) {
        return this.createClusterWithCount(count, new Config());
    }

    protected HazelcastInstance[] createClusterWithCount(int count, Config config) {
        this.factory = new TestHazelcastFactory();
        HazelcastInstance[] instances = this.factory.newInstances(config, count);
        ClientScheduledExecutorServiceBasicTest.waitAllForSafeState((HazelcastInstance[])instances);
        return instances;
    }

    public IScheduledExecutorService getScheduledExecutor(HazelcastInstance[] instances, String name) {
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        return this.factory.newHazelcastClient(config).getScheduledExecutorService(name);
    }

    @Test
    @Ignore(value="Never supported feature")
    public void schedule_testPartitionLostEvent_withDurabilityCount() {
    }

    @Test
    @Ignore(value="Never supported feature")
    public void schedule_testPartitionLostEvent_withMaxBackupCount() {
    }

    @Test
    @Ignore(value="Never supported feature")
    public void scheduleOnMember_testMemberLostEvent() {
    }
}

