/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.semaphore;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientSemaphoreTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testSemaphoreInit() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        Assert.assertTrue((boolean)semaphore.init(10));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSemaphoreNegInit() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(-1);
    }

    @Test
    public void testRelease() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        semaphore.release();
        Assert.assertEquals((long)1L, (long)semaphore.availablePermits());
    }

    @Test
    public void testdrainPermits() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(10);
        Assert.assertEquals((long)10L, (long)semaphore.drainPermits());
    }

    @Test
    public void testAvailablePermits_AfterDrainPermits() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(10);
        semaphore.drainPermits();
        Assert.assertEquals((long)0L, (long)semaphore.availablePermits());
    }

    @Test
    public void testTryAcquire_whenDrainPermits() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(10);
        semaphore.drainPermits();
        Assert.assertFalse((boolean)semaphore.tryAcquire());
    }

    @Test
    public void testAvailablePermits() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(10);
        Assert.assertEquals((long)10L, (long)semaphore.availablePermits());
    }

    @Test
    public void testAvailableReducePermits() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(10);
        semaphore.reducePermits(5);
        Assert.assertEquals((long)5L, (long)semaphore.availablePermits());
    }

    @Test
    public void testAvailableReducePermits_WhenZero() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        semaphore.reducePermits(1);
        Assert.assertEquals((long)-1L, (long)semaphore.availablePermits());
    }

    @Test
    public void testAvailableIncreasePermits() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(10);
        semaphore.drainPermits();
        semaphore.increasePermits(5);
        Assert.assertEquals((long)5L, (long)semaphore.availablePermits());
    }

    @Test
    public void testAvailableIncreasePermits_WhenIncreasedFromZero() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        semaphore.increasePermits(1);
        Assert.assertEquals((long)1L, (long)semaphore.availablePermits());
    }

    @Test
    public void testNegativePermitsJucCompatibility() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        semaphore.reducePermits(100);
        semaphore.release(10);
        Assert.assertEquals((long)-90L, (long)semaphore.availablePermits());
        Assert.assertEquals((long)-90L, (long)semaphore.drainPermits());
        semaphore.release(10);
        Assert.assertEquals((long)10L, (long)semaphore.availablePermits());
        Assert.assertEquals((long)10L, (long)semaphore.drainPermits());
    }

    @Test
    public void testTryAcquire_whenAvailable() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(1);
        Assert.assertTrue((boolean)semaphore.tryAcquire());
    }

    @Test
    public void testTryAcquire_whenUnAvailable() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        Assert.assertFalse((boolean)semaphore.tryAcquire());
    }

    @Test
    public void testTryAcquire_whenAvailableWithTimeOut() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(1);
        Assert.assertTrue((boolean)semaphore.tryAcquire(1L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testTryAcquire_whenUnAvailableWithTimeOut() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        Assert.assertFalse((boolean)semaphore.tryAcquire(1L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testTryAcquireMultiPermits_whenAvailable() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(10);
        Assert.assertTrue((boolean)semaphore.tryAcquire(5));
    }

    @Test
    public void testTryAcquireMultiPermits_whenUnAvailable() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(5);
        Assert.assertFalse((boolean)semaphore.tryAcquire(10));
    }

    @Test
    public void testTryAcquireMultiPermits_whenAvailableWithTimeOut() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(10);
        Assert.assertTrue((boolean)semaphore.tryAcquire(5, 1L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testTryAcquireMultiPermits_whenUnAvailableWithTimeOut() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(5);
        Assert.assertFalse((boolean)semaphore.tryAcquire(10, 1L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testTryAcquire_afterRelease() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        semaphore.release();
        Assert.assertTrue((boolean)semaphore.tryAcquire());
    }

    @Test
    public void testMulitReleaseTryAcquire() throws Exception {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        semaphore.release(5);
        Assert.assertTrue((boolean)semaphore.tryAcquire(5));
    }

    @Test
    public void testAcquire_Threaded() throws Exception {
        final ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    semaphore.acquire();
                    latch.countDown();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        HazelcastTestSupport.sleepSeconds((int)1);
        semaphore.release(2);
        Assert.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)semaphore.availablePermits());
    }

    @Test
    public void tryAcquire_Threaded() throws Exception {
        final ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(0);
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    if (semaphore.tryAcquire(1, 5L, TimeUnit.SECONDS)) {
                        latch.countDown();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        semaphore.release(2);
        Assert.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)semaphore.availablePermits());
    }
}

