/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.stress;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.stress.StressTestSupport;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class})
public class MapStableReadStressTest
extends StressTestSupport {
    public static final int CLIENT_THREAD_COUNT = 5;
    public static final int MAP_SIZE = 100000;
    private HazelcastInstance client;
    private IMap<Integer, Integer> map;
    private StressThread[] stressThreads;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setRedoOperation(true);
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        this.map = this.client.getMap("map");
        this.stressThreads = new StressThread[5];
        for (int k = 0; k < this.stressThreads.length; ++k) {
            this.stressThreads[k] = new StressThread();
            this.stressThreads[k].start();
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    @Test(timeout=600000L)
    public void testChangingCluster() {
        this.test(true);
    }

    @Test(timeout=600000L)
    public void testFixedCluster() {
        this.test(false);
    }

    public void test(boolean clusterChangeEnabled) {
        this.setClusterChangeEnabled(clusterChangeEnabled);
        this.fillMap();
        this.startAndWaitForTestCompletion();
        this.joinAll(this.stressThreads);
    }

    private void fillMap() {
        long timeMillis = System.currentTimeMillis();
        System.out.println("==================================================================");
        System.out.println("Inserting data in map");
        System.out.println("==================================================================");
        for (int k = 0; k < 100000; ++k) {
            this.map.put((Object)k, (Object)k);
            if (k % 10000 != 0) continue;
            System.out.println("Inserted data: " + k);
        }
        long timeTookToInsertData = System.currentTimeMillis() - timeMillis;
        System.out.println("==================================================================");
        System.out.println("Completed with inserting data in map in " + timeTookToInsertData + " millis ");
        System.out.println("==================================================================");
    }

    public class StressThread
    extends StressTestSupport.TestThread {
        @Override
        public void doRun() throws Exception {
            while (!MapStableReadStressTest.this.isStopped()) {
                int key = this.random.nextInt(100000);
                int value = (Integer)MapStableReadStressTest.this.map.get((Object)key);
                Assert.assertEquals((String)"The value for the key was not consistent", (long)key, (long)value);
            }
        }
    }
}

