/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.test;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.impl.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestClientRegistry;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.test.TestEnvironment;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class TestHazelcastFactory
extends TestHazelcastInstanceFactory {
    private static final AtomicInteger CLIENT_PORTS = new AtomicInteger(40000);
    private final boolean mockNetwork = TestEnvironment.isMockNetwork();
    private final List<HazelcastClientInstanceImpl> clients = new ArrayList<HazelcastClientInstanceImpl>(10);
    private final TestClientRegistry clientRegistry = new TestClientRegistry(this.getRegistry());

    public TestHazelcastFactory() {
        this(0);
    }

    public TestHazelcastFactory(int count) {
        super(count);
    }

    public HazelcastInstance newHazelcastClient() {
        return this.newHazelcastClient(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HazelcastInstance newHazelcastClient(ClientConfig config) {
        HazelcastClientProxy proxy;
        if (!this.mockNetwork) {
            return HazelcastClient.newHazelcastClient((ClientConfig)config);
        }
        if (config == null) {
            config = new XmlClientConfigBuilder().build();
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (tccl == ClassLoader.getSystemClassLoader()) {
                Thread.currentThread().setContextClassLoader(HazelcastClient.class.getClassLoader());
            }
            ClientConnectionManagerFactory clientConnectionManagerFactory = this.clientRegistry.createClientServiceFactory("127.0.0.1", CLIENT_PORTS);
            AddressProvider testAddressProvider = this.createAddressProvider(config);
            HazelcastClientInstanceImpl client = new HazelcastClientInstanceImpl(config, clientConnectionManagerFactory, testAddressProvider);
            client.start();
            this.clients.add(client);
            OutOfMemoryErrorDispatcher.registerClient((HazelcastInstance)client);
            proxy = new HazelcastClientProxy(client);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return proxy;
    }

    private AddressProvider createAddressProvider(ClientConfig config) {
        boolean isAtLeastAProviderConfigured;
        boolean discoveryEnabled = new HazelcastProperties(config.getProperties()).getBoolean(ClientProperty.DISCOVERY_SPI_ENABLED);
        ClientAwsConfig awsConfig = config.getNetworkConfig().getAwsConfig();
        List userConfiguredAddresses = config.getNetworkConfig().getAddresses();
        boolean bl = isAtLeastAProviderConfigured = discoveryEnabled || awsConfig != null && awsConfig.isEnabled() || !userConfiguredAddresses.isEmpty();
        if (isAtLeastAProviderConfigured) {
            return null;
        }
        return new AddressProvider(){

            public Collection<Address> loadAddresses() {
                ArrayList<Address> possibleAddresses = new ArrayList<Address>();
                for (Address address : TestHazelcastFactory.this.getKnownAddresses()) {
                    Collection addresses = AddressHelper.getPossibleSocketAddresses((int)address.getPort(), (String)address.getHost(), (int)1);
                    possibleAddresses.addAll(addresses);
                }
                return possibleAddresses;
            }
        };
    }

    public void shutdownAllMembers() {
        super.shutdownAll();
    }

    public void shutdownAll() {
        if (this.mockNetwork) {
            for (HazelcastClientInstanceImpl client : this.clients) {
                client.shutdown();
            }
        } else {
            HazelcastClient.shutdownAll();
        }
        super.shutdownAll();
    }

    public void terminateAll() {
        if (this.mockNetwork) {
            for (HazelcastClientInstanceImpl client : this.clients) {
                client.getLifecycleService().terminate();
            }
        } else {
            HazelcastClient.shutdownAll();
        }
        super.terminateAll();
    }
}

