/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.test.bounce;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.bounce.BounceMemberRule;
import com.hazelcast.test.bounce.BounceTestConfiguration;
import com.hazelcast.test.bounce.DriverFactory;

public abstract class AbstractClientDriverFactory
implements DriverFactory {
    protected ClientConfig clientConfig;

    public AbstractClientDriverFactory() {
    }

    public AbstractClientDriverFactory(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public HazelcastInstance[] createTestDrivers(BounceMemberRule rule) {
        BounceTestConfiguration testConfiguration = rule.getBounceTestConfig();
        switch (testConfiguration.getDriverType()) {
            case CLIENT: {
                HazelcastInstance[] drivers = new HazelcastInstance[testConfiguration.getDriverCount()];
                for (int i = 0; i < drivers.length; ++i) {
                    drivers[i] = ((TestHazelcastFactory)rule.getFactory()).newHazelcastClient(this.getClientConfig(rule.getSteadyMember()));
                }
                HazelcastTestSupport.waitAllForSafeState((HazelcastInstance[])drivers);
                return drivers;
            }
        }
        throw new AssertionError((Object)("ClientDriverFactory cannot create test drivers for " + testConfiguration.getDriverType()));
    }

    protected abstract ClientConfig getClientConfig(HazelcastInstance var1);
}

