/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTxnReconnectModeTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    @Parameterized.Parameter
    public boolean smartRouting;

    @Parameterized.Parameters(name="smartRouting:{0} ")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=OperationTimeoutException.class)
    public void testNewTransactionContext_ReconnectMode_ON() throws Throwable {
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        config.getNetworkConfig().setSmartRouting(this.smartRouting);
        config.getConnectionStrategyConfig().setAsyncStart(true);
        config.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "3");
        config.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ON);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        try {
            client.newTransactionContext();
        }
        catch (TransactionException e) {
            throw e.getCause();
        }
    }

    @Test(expected=HazelcastClientOfflineException.class)
    public void testNewTransactionContext_ReconnectMode_ASYNC() throws Throwable {
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        config.getNetworkConfig().setSmartRouting(this.smartRouting);
        config.getConnectionStrategyConfig().setAsyncStart(true);
        config.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        try {
            client.newTransactionContext();
        }
        catch (TransactionException e) {
            throw e.getCause();
        }
    }

    @Test(expected=HazelcastClientNotActiveException.class)
    public void testNewTransactionContext_After_shutdown() throws Throwable {
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        config.getNetworkConfig().setSmartRouting(this.smartRouting);
        config.getConnectionStrategyConfig().setAsyncStart(true);
        config.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        client.shutdown();
        try {
            client.newTransactionContext();
        }
        catch (TransactionException e) {
            throw e.getCause();
        }
    }
}

