/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.usercodedeployment;

import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.spi.impl.ClientUserCodeDeploymentService;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import usercodedeployment.IncrementingEntryProcessor;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientUserCodeDeploymentConfigTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() throws Exception {
        this.factory.terminateAll();
    }

    @Test
    public void testConfigWithClassName() throws IOException, ClassNotFoundException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        String className = "usercodedeployment.IncrementingEntryProcessor";
        config.addClass(className);
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, ((Object)((Object)this)).getClass().getClassLoader());
        service.start();
        List list = service.getClassDefinitionList();
        this.assertClassLoaded(list, className);
    }

    @Test(expected=ClassNotFoundException.class)
    public void testConfigWithWrongClassName() throws ClassNotFoundException, IOException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        String className = "NonExistingClass";
        config.addClass(className);
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, ((Object)((Object)this)).getClass().getClassLoader());
        service.start();
    }

    @Test
    public void testConfigWithClass() throws ClassNotFoundException, IOException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        config.addClass(IncrementingEntryProcessor.class);
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, ((Object)((Object)this)).getClass().getClassLoader());
        service.start();
        List list = service.getClassDefinitionList();
        this.assertClassLoaded(list, IncrementingEntryProcessor.class.getName());
    }

    @Test
    public void testConfigWithJarPath() throws ClassNotFoundException, IOException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        config.addJar("IncrementingEntryProcessor.jar");
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, classLoader);
        service.start();
        List list = service.getClassDefinitionList();
        this.assertClassLoaded(list, "usercodedeployment.IncrementingEntryProcessor");
    }

    @Test
    public void testConfigWithClasses() throws ClassNotFoundException, IOException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        config.setClassNames(Collections.singletonList("usercodedeployment.IncrementingEntryProcessor"));
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, ((Object)((Object)this)).getClass().getClassLoader());
        service.start();
        List list = service.getClassDefinitionList();
        this.assertClassLoaded(list, IncrementingEntryProcessor.class.getName());
    }

    @Test
    public void testConfigWithJarPaths() throws ClassNotFoundException, IOException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        config.setJarPaths(Collections.singletonList("IncrementingEntryProcessor.jar"));
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, classLoader);
        service.start();
        List list = service.getClassDefinitionList();
        this.assertClassLoaded(list, "usercodedeployment.IncrementingEntryProcessor");
    }

    @Test
    public void testConfigWithURLPath() throws ClassNotFoundException, IOException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL resource = classLoader.getResource("IncrementingEntryProcessor.jar");
        config.addJar(resource.toExternalForm());
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, classLoader);
        service.start();
        List list = service.getClassDefinitionList();
        this.assertClassLoaded(list, "usercodedeployment.IncrementingEntryProcessor");
    }

    @Test(expected=FileNotFoundException.class)
    public void testConfigWithWrongJarPath() throws ClassNotFoundException, IOException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        config.addJar("/wrongPath/IncrementingEntryProcessor.jar");
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, classLoader);
        service.start();
    }

    @Test(expected=FileNotFoundException.class)
    public void testConfigWithFileDoesNotExist() throws ClassNotFoundException, IOException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        File file = new File("/wrongPath/IncrementingEntryProcessor.jar");
        config.addJar(file);
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, classLoader);
        service.start();
    }

    @Test
    public void testConfigWithJarFile() throws URISyntaxException, ClassNotFoundException, IOException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL resource = classLoader.getResource("IncrementingEntryProcessor.jar");
        File file = new File(resource.toURI());
        config.addJar(file);
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, classLoader);
        service.start();
        List list = service.getClassDefinitionList();
        this.assertClassLoaded(list, "usercodedeployment.IncrementingEntryProcessor");
    }

    private void assertClassLoaded(List<Map.Entry<String, byte[]>> list, String name) {
        for (Map.Entry<String, byte[]> classDefinition : list) {
            if (!classDefinition.getKey().equals(name)) continue;
            return;
        }
        Assert.fail();
    }

    @Test
    public void testConfigWithJarFile_withInnerAndAnonymousClass() throws IOException, URISyntaxException, ClassNotFoundException {
        ClientUserCodeDeploymentConfig config = new ClientUserCodeDeploymentConfig();
        config.setEnabled(true);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL resource = classLoader.getResource("EntryProcessorWithAnonymousAndInner.jar");
        File file = new File(resource.toURI());
        config.addJar(file);
        ClientUserCodeDeploymentService service = new ClientUserCodeDeploymentService(config, classLoader);
        service.start();
        List list = service.getClassDefinitionList();
        this.assertClassLoaded(list, "usercodedeployment.EntryProcessorWithAnonymousAndInner");
        this.assertClassLoaded(list, "usercodedeployment.EntryProcessorWithAnonymousAndInner$1");
        this.assertClassLoaded(list, "usercodedeployment.EntryProcessorWithAnonymousAndInner$Test");
    }
}

