/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.util.ClientStateListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.FutureUtil;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientStateListenerTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(timeout=600000L)
    public void testWithUnusedClientConfig() throws InterruptedException {
        ClientConfig clientConfig = new ClientConfig();
        ClientStateListener listener = new ClientStateListener(clientConfig);
        Assert.assertFalse((boolean)listener.awaitConnected(1L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)listener.awaitDisconnected(1L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)listener.isConnected());
        Assert.assertFalse((boolean)listener.isShutdown());
        Assert.assertFalse((boolean)listener.isStarted());
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.STARTING, (Object)listener.getCurrentState());
    }

    @Test(timeout=600000L)
    public void testClientASYNCStartConnected() throws InterruptedException {
        ClientConfig clientConfig = new ClientConfig();
        ClientStateListener listener = new ClientStateListener(clientConfig);
        clientConfig.getConnectionStrategyConfig().setAsyncStart(true);
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        Assert.assertTrue((boolean)listener.awaitConnected());
        Assert.assertFalse((boolean)listener.awaitDisconnected(1L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)listener.isConnected());
        Assert.assertFalse((boolean)listener.isShutdown());
        Assert.assertTrue((boolean)listener.isStarted());
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED, (Object)listener.getCurrentState());
    }

    @Test(timeout=600000L)
    public void testClientReconnectModeAsyncConnected() throws InterruptedException {
        ClientConfig clientConfig = new ClientConfig();
        ClientStateListener listener = new ClientStateListener(clientConfig);
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        hazelcastInstance.shutdown();
        Assert.assertTrue((boolean)listener.awaitDisconnected());
        Assert.assertFalse((boolean)listener.isConnected());
        Assert.assertFalse((boolean)listener.isShutdown());
        Assert.assertTrue((boolean)listener.isStarted());
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED, (Object)listener.getCurrentState());
        this.hazelcastFactory.newHazelcastInstance();
        Assert.assertTrue((boolean)listener.awaitConnected());
        Assert.assertTrue((boolean)listener.isConnected());
        Assert.assertFalse((boolean)listener.isShutdown());
        Assert.assertTrue((boolean)listener.isStarted());
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED, (Object)listener.getCurrentState());
    }

    @Test(timeout=600000L)
    public void testClientReconnectModeAsyncConnectedMultipleThreads() throws InterruptedException {
        int i;
        int numThreads = 10;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        ClientConfig clientConfig = new ClientConfig();
        final ClientStateListener listener = new ClientStateListener(clientConfig);
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        hazelcastInstance.shutdown();
        ArrayList futures = new ArrayList(numThreads);
        for (i = 0; i < numThreads; ++i) {
            futures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Assert.assertTrue((boolean)listener.awaitDisconnected());
                    }
                    catch (InterruptedException e) {
                        Assert.fail((String)"Should not be interrupted");
                    }
                    Assert.assertFalse((boolean)listener.isConnected());
                    Assert.assertFalse((boolean)listener.isShutdown());
                    Assert.assertTrue((boolean)listener.isStarted());
                    Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED, (Object)listener.getCurrentState());
                }
            }));
        }
        FutureUtil.waitForever(futures);
        Assert.assertTrue((boolean)FutureUtil.allDone(futures));
        this.hazelcastFactory.newHazelcastInstance();
        futures.clear();
        for (i = 0; i < numThreads; ++i) {
            futures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.awaitConnected();
                    }
                    catch (InterruptedException e) {
                        Assert.fail((String)"Should not be interrupted");
                    }
                    Assert.assertTrue((boolean)listener.isConnected());
                    Assert.assertFalse((boolean)listener.isShutdown());
                    Assert.assertTrue((boolean)listener.isStarted());
                    Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED, (Object)listener.getCurrentState());
                }
            }));
        }
        FutureUtil.waitForever(futures);
        Assert.assertTrue((boolean)FutureUtil.allDone(futures));
    }

    @Test(timeout=600000L)
    public void testClientReconnectModeOffDisconnected() throws InterruptedException {
        ClientConfig clientConfig = new ClientConfig();
        final ClientStateListener listener = new ClientStateListener(clientConfig);
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.OFF);
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        hazelcastInstance.shutdown();
        this.hazelcastFactory.newHazelcastInstance();
        Assert.assertTrue((boolean)listener.awaitDisconnected());
        Assert.assertFalse((boolean)listener.isConnected());
        ClientStateListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)LifecycleEvent.LifecycleState.SHUTDOWN, (Object)listener.getCurrentState());
            }
        });
        Assert.assertFalse((boolean)listener.isStarted());
    }

    @Test(timeout=600000L)
    public void testClientConnectedWithTimeout() throws InterruptedException {
        ClientConfig clientConfig = new ClientConfig();
        ClientStateListener listener = new ClientStateListener(clientConfig);
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        Assert.assertTrue((boolean)listener.awaitConnected());
        Assert.assertFalse((boolean)listener.awaitDisconnected(1L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)listener.isConnected());
        Assert.assertFalse((boolean)listener.isShutdown());
        Assert.assertTrue((boolean)listener.isStarted());
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED, (Object)listener.getCurrentState());
    }

    @Test(timeout=600000L)
    public void testClientConnectedWithoutTimeout() throws InterruptedException {
        ClientConfig clientConfig = new ClientConfig();
        ClientStateListener listener = new ClientStateListener(clientConfig);
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        listener.awaitConnected();
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED, (Object)listener.getCurrentState());
        Assert.assertTrue((boolean)listener.isConnected());
        Assert.assertTrue((boolean)listener.isStarted());
        Assert.assertFalse((boolean)listener.awaitDisconnected(1L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)listener.isShutdown());
    }

    @Test(timeout=600000L)
    public void testClientDisconnectedWithTimeout() throws InterruptedException {
        ClientConfig clientConfig = new ClientConfig();
        ClientStateListener listener = new ClientStateListener(clientConfig);
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient(clientConfig).shutdown();
        Assert.assertFalse((boolean)listener.awaitConnected(1L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)listener.awaitDisconnected(1L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)listener.isConnected());
        Assert.assertTrue((boolean)listener.isShutdown());
        Assert.assertFalse((boolean)listener.isStarted());
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.SHUTDOWN, (Object)listener.getCurrentState());
    }

    @Test(timeout=600000L)
    public void testClientDisconnectedWithoutTimeout() throws InterruptedException {
        ClientConfig clientConfig = new ClientConfig();
        ClientStateListener listener = new ClientStateListener(clientConfig);
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient(clientConfig).shutdown();
        listener.awaitDisconnected();
        Assert.assertFalse((boolean)listener.awaitConnected(1L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)listener.isConnected());
        Assert.assertTrue((boolean)listener.isShutdown());
        Assert.assertFalse((boolean)listener.isStarted());
        Assert.assertEquals((Object)LifecycleEvent.LifecycleState.SHUTDOWN, (Object)listener.getCurrentState());
    }
}

