/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestAwareClientFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientDeserializationProtectionTest {
    private final TestAwareClientFactory factory = new TestAwareClientFactory();

    @After
    public void killAllHazelcastInstances() throws IOException {
        this.factory.terminateAll();
    }

    @Test
    public void test() throws Exception {
        HazelcastInstance hz = this.factory.newHazelcastInstance(null);
        ClientConfig config = new ClientConfig();
        config.setProperty(GroupProperty.SERIALIZATION_FILTER_ENABLED.getName(), "true");
        config.setProperty(GroupProperty.SERIALIZATION_FILTER_BLACKLIST_CLASSES.getName(), TestDeserialized.class.getName());
        HazelcastInstance client = this.factory.newHazelcastClient(config);
        hz.getMap("test").put((Object)"test", (Object)new TestDeserialized());
        try {
            client.getMap("test").get((Object)"test");
            Assert.fail((String)"Deserialization should fail");
        }
        catch (HazelcastSerializationException s) {
            Assert.assertEquals((String)"SecurityException was expected as a cause of failed deserialization", SecurityException.class, s.getCause().getClass());
            Assert.assertFalse((String)"Untrusted deserialization was possible", (boolean)TestDeserialized.IS_DESERIALIZED);
        }
    }

    public static class TestDeserialized
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static volatile boolean IS_DESERIALIZED = false;

        private void writeObject(ObjectOutputStream out) throws IOException {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            IS_DESERIALIZED = true;
        }
    }
}

