/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientDisconnectTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testClientOperationCancelled_whenDisconnected() throws Exception {
        Config config = new Config();
        config.setProperty(GroupProperty.CLIENT_ENDPOINT_REMOVE_DELAY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        String queueName = "q";
        final HazelcastInstance clientInstance = this.hazelcastFactory.newHazelcastClient();
        final String uuid = clientInstance.getLocalEndpoint().getUuid();
        final CountDownLatch clientDisconnectedFromNode = new CountDownLatch(1);
        hazelcastInstance.getClientService().addClientListener(new ClientListener(){

            public void clientConnected(Client client) {
            }

            public void clientDisconnected(Client client) {
                if (client.getUuid().equals(uuid)) {
                    clientDisconnectedFromNode.countDown();
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                IQueue queue = clientInstance.getQueue("q");
                try {
                    queue.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (HazelcastInstanceNotActiveException e) {
                    HazelcastTestSupport.ignore((Throwable)e);
                }
            }
        }).start();
        TimeUnit.SECONDS.sleep(2L);
        clientInstance.shutdown();
        ClientDisconnectTest.assertOpenEventually((CountDownLatch)clientDisconnectedFromNode);
        final IQueue queue = hazelcastInstance.getQueue("q");
        queue.add((Object)1);
        ClientDisconnectTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)queue.size(), (long)1L);
            }
        }, (long)3L);
    }

    @Test
    public void testClientOperationCancelled_whenDisconnected_lock() throws Exception {
        Config config = new Config();
        config.setProperty(GroupProperty.CLIENT_ENDPOINT_REMOVE_DELAY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        String name = "m";
        final IMap map = hazelcastInstance.getMap("m");
        String key = "key";
        map.lock((Object)"key");
        final HazelcastInstance clientInstance = this.hazelcastFactory.newHazelcastClient();
        final CountDownLatch clientDisconnectedFromNode = new CountDownLatch(1);
        final String uuid = clientInstance.getLocalEndpoint().getUuid();
        hazelcastInstance.getClientService().addClientListener(new ClientListener(){

            public void clientConnected(Client client) {
            }

            public void clientDisconnected(Client client) {
                if (client.getUuid().equals(uuid)) {
                    clientDisconnectedFromNode.countDown();
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                IMap clientMap = clientInstance.getMap("m");
                try {
                    clientMap.lock((Object)"key");
                }
                catch (Exception e) {
                    HazelcastTestSupport.ignore((Throwable)e);
                }
            }
        }).start();
        TimeUnit.SECONDS.sleep(2L);
        clientInstance.shutdown();
        ClientDisconnectTest.assertOpenEventually((CountDownLatch)clientDisconnectedFromNode);
        map.unlock((Object)"key");
        ClientDisconnectTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((boolean)map.isLocked((Object)"key"));
            }
        }, (long)3L);
    }
}

