/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientOwnershipTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void test_clientOwnedByMember() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        String instanceUuid = instance.getLocalEndpoint().getUuid();
        String clientUuid = client.getLocalEndpoint().getUuid();
        ClientEngineImpl clientEngine = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance);
        Assert.assertEquals((Object)instanceUuid, (Object)clientEngine.getOwnerUuid(clientUuid));
        this.assertClientEndpointExists(clientEngine, clientUuid, true);
    }

    @Test
    public void test_clientOwnedInfoPropagatedToAllMembers() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        final String instanceUuid = instance1.getLocalEndpoint().getUuid();
        final String clientUuid = client.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine1 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance1);
        final ClientEngineImpl clientEngine2 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine1.getOwnerUuid(clientUuid));
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine2.getOwnerUuid(clientUuid));
                ClientOwnershipTest.this.assertClientEndpointExists(clientEngine1, clientUuid, true);
                ClientOwnershipTest.this.assertClientEndpointExists(clientEngine2, clientUuid, false);
            }
        });
    }

    @Test
    public void test_clientOwnedBySecondMember_afterFirstOwnerDies() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        instance1.shutdown();
        final String instance2Uuid = instance2.getLocalEndpoint().getUuid();
        final String clientUuid = client.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instance2Uuid, (Object)clientEngine.getOwnerUuid(clientUuid));
                ClientOwnershipTest.this.assertClientEndpointExists(clientEngine, clientUuid, true);
            }
        });
    }

    @Test
    public void test_clientOwnedByAlreadyConnectedSecondMember_afterFirstOwnerDies() {
        final HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        final HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        IExecutorService exec = client.getExecutorService("exec");
        exec.submitToAllMembers((Callable)new HazelcastTestSupport.DummySerializableCallable());
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)instance1.getClientService().getConnectedClients().size());
                Assert.assertEquals((long)1L, (long)instance2.getClientService().getConnectedClients().size());
            }
        });
        instance1.shutdown();
        final String instance2Uuid = instance2.getLocalEndpoint().getUuid();
        final String clientUuid = client.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instance2Uuid, (Object)clientEngine.getOwnerUuid(clientUuid));
                ClientOwnershipTest.this.assertClientEndpointExists(clientEngine, clientUuid, true);
            }
        });
    }

    private void assertClientEndpointExists(ClientEngineImpl clientEngine, String clientUuid, boolean asOwner) {
        Set endpoints = clientEngine.getEndpointManager().getEndpoints(clientUuid);
        Assert.assertEquals((long)1L, (long)endpoints.size());
        ClientEndpoint endpoint = (ClientEndpoint)endpoints.iterator().next();
        if (asOwner) {
            Assert.assertTrue((boolean)endpoint.isOwnerConnection());
        } else {
            Assert.assertTrue((!endpoint.isOwnerConnection() ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_ownerShipRemoved_afterClientDies() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        final String instanceUuid = instance1.getLocalEndpoint().getUuid();
        final String clientUuid = client.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine1 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance1);
        final ClientEngineImpl clientEngine2 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine1.getOwnerUuid(clientUuid));
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine2.getOwnerUuid(clientUuid));
            }
        });
        client.shutdown();
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertNull((Object)clientEngine1.getOwnerUuid(clientUuid));
                Assert.assertNull((Object)clientEngine2.getOwnerUuid(clientUuid));
                Assert.assertEquals((long)0L, (long)clientEngine1.getEndpointManager().getEndpoints(clientUuid).size());
                Assert.assertEquals((long)0L, (long)clientEngine2.getEndpointManager().getEndpoints(clientUuid).size());
            }
        });
    }

    @Test
    public void test_ownerShip_afterClusterRestart() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        instance.shutdown();
        final HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                HazelcastTestSupport.assertClusterSize((int)1, (HazelcastInstance[])new HazelcastInstance[]{client});
                HazelcastTestSupport.assertClusterSize((int)1, (HazelcastInstance[])new HazelcastInstance[]{instance2});
            }
        });
        final String instanceUuid = instance2.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine2 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        final String clientUuid = client.getLocalEndpoint().getUuid();
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine2.getOwnerUuid(clientUuid));
                ClientOwnershipTest.this.assertClientEndpointExists(clientEngine2, clientUuid, true);
            }
        });
    }

    @Test
    public void test_ownerShip_whenSmartClientAndOwnerDiesTogether() {
        this.test_ownerShip_whenClientAndOwnerDiesTogether(true);
    }

    @Test
    public void test_ownerShip_whenNonSmartClientAndOwnerDiesTogether() {
        this.test_ownerShip_whenClientAndOwnerDiesTogether(false);
    }

    private void test_ownerShip_whenClientAndOwnerDiesTogether(boolean smart) {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setSmartRouting(smart);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        final String clientUuid = client.getLocalEndpoint().getUuid();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        client.getLifecycleService().terminate();
        instance.getLifecycleService().terminate();
        HazelcastInstance instance3 = this.hazelcastFactory.newHazelcastInstance();
        final ClientEngineImpl clientEngine3 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance3);
        final ClientEngineImpl clientEngine2 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertNull((Object)clientEngine2.getOwnerUuid(clientUuid));
                Assert.assertNull((Object)clientEngine3.getOwnerUuid(clientUuid));
                Assert.assertEquals((long)0L, (long)clientEngine2.getEndpointManager().getEndpoints(clientUuid).size());
                Assert.assertEquals((long)0L, (long)clientEngine3.getEndpointManager().getEndpoints(clientUuid).size());
            }
        });
    }

    @Test
    public void test_ownerShipCarried_inJoin() throws InterruptedException {
        this.hazelcastFactory.newHazelcastInstance();
        final AtomicReference clientUUID = new AtomicReference();
        int clientCount = 20;
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < 20; ++i) {
                    ClientConfig config = new ClientConfig();
                    config.getNetworkConfig().setConnectionTimeout(30000);
                    HazelcastInstance client = ClientOwnershipTest.this.hazelcastFactory.newHazelcastClient(config);
                    list.add(client.getLocalEndpoint().getUuid());
                }
                clientUUID.set(list);
            }
        }).start();
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        final ClientEngineImpl clientEngineImpl = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                List list = (List)clientUUID.get();
                Assert.assertNotNull((Object)list);
                for (String clientUuid : list) {
                    Assert.assertNotNull((String)(clientUuid + " " + list.size()), (Object)clientEngineImpl.getOwnerUuid(clientUuid));
                }
            }
        });
    }
}

