/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.cache.CacheUtil;
import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.nearcache.ClientNearCacheTestSupport;
import com.hazelcast.client.cache.nearcache.ClientCacheInvalidationListener;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.instance.LifecycleServiceImpl;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheInvalidationListener;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.cache.CacheManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={SlowTest.class})
public class ClientNearCacheInvalidationTest
extends HazelcastTestSupport {
    static final String DEFAULT_CACHE_NAME = "com.hazelcast.client.cache.impl.nearcache.ClientNearCacheInvalidationTest";
    static final int TIMEOUT = 10;
    static final int MEMBER_COUNT = 2;
    static final int INITIAL_POPULATION_COUNT = 1000;
    @Parameterized.Parameter
    public boolean invokeCacheOperationsFromMember;
    @Parameterized.Parameter(value=1)
    public InMemoryFormat inMemoryFormat;
    private TestHazelcastFactory hazelcastFactory;
    private NearCacheTestContext<Integer, String, Object, String> testContext;

    @Parameterized.Parameters(name="fromMember:{0}, format:{1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false, InMemoryFormat.BINARY}, {false, InMemoryFormat.OBJECT}, {true, InMemoryFormat.BINARY}, {true, InMemoryFormat.OBJECT});
    }

    @Before
    public void setup() {
        this.hazelcastFactory = new TestHazelcastFactory();
        HazelcastInstance[] allMembers = new HazelcastInstance[2];
        for (int i = 0; i < 2; ++i) {
            allMembers[i] = this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        }
        ClientNearCacheInvalidationTest.waitAllForSafeState((HazelcastInstance[])allMembers);
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(this.inMemoryFormat);
        ClientConfig clientConfig = this.createClientConfig().addNearCacheConfig(nearCacheConfig);
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastServerCachingProvider memberProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)allMembers[0]);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        HazelcastServerCacheManager memberCacheManager = (HazelcastServerCacheManager)memberProvider.getCacheManager();
        CacheConfig cacheConfig = this.createCacheConfig(this.inMemoryFormat);
        ICache cache = cacheManager.createCache(DEFAULT_CACHE_NAME, cacheConfig);
        ICache memberCache = memberCacheManager.getCache(CacheUtil.getPrefixedCacheName((String)DEFAULT_CACHE_NAME, null, null));
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache(cacheManager.getCacheNameWithPrefix(DEFAULT_CACHE_NAME));
        SerializationService serializationService = client.getSerializationService();
        NearCacheTestContextBuilder builder = new NearCacheTestContextBuilder(nearCacheConfig, serializationService);
        this.testContext = builder.setDataInstance(allMembers[0]).setNearCacheInstance((HazelcastInstance)client).setDataAdapter((DataStructureAdapter)new ICacheDataStructureAdapter(memberCache)).setNearCacheAdapter((DataStructureAdapter)new ICacheDataStructureAdapter(cache)).setMemberCacheManager(memberCacheManager).setCacheManager((CacheManager)cacheManager).setNearCacheManager(nearCacheManager).setNearCache(nearCache).setInvalidationListener(ClientCacheInvalidationListener.createInvalidationEventHandler(cache)).build();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected Config getConfig() {
        return super.getConfig().setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "false");
    }

    @Test
    public void putToCacheAndGetInvalidationEventWhenNodeShutdown() {
        String key;
        Config config = this.getConfig().setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true").setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(Integer.MAX_VALUE)).setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance instanceToShutdown = this.hazelcastFactory.newHazelcastInstance(config);
        ClientNearCacheInvalidationTest.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{this.testContext.dataInstance, instanceToShutdown});
        ClientNearCacheInvalidationTest.waitAllForSafeState((HazelcastInstance[])new HazelcastInstance[]{this.testContext.dataInstance, instanceToShutdown});
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(this.inMemoryFormat).setInvalidateOnChange(true).setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE);
        CacheConfig cacheConfig = this.createCacheConfig(this.inMemoryFormat);
        final NearCacheTestContext nearCacheTestContext1 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig, cacheConfig);
        NearCacheTestContext nearCacheTestContext2 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig, cacheConfig);
        HashMap<String, String> keyAndValues = new HashMap<String, String>();
        for (int i = 0; i < 1000; ++i) {
            String key2 = ClientNearCacheInvalidationTest.generateKeyOwnedBy((HazelcastInstance)instanceToShutdown);
            String value = ClientNearCacheTestSupport.generateValueFromKey(i);
            nearCacheTestContext1.nearCacheAdapter.put((Object)key2, (Object)value);
            keyAndValues.put(key2, value);
        }
        for (Map.Entry entry : keyAndValues.entrySet()) {
            key = (String)entry.getKey();
            String exceptedValue = (String)entry.getValue();
            String actualValue = (String)ClientNearCacheInvalidationTest.getFromNearCache(nearCacheTestContext1, key);
            Assert.assertEquals((Object)exceptedValue, (Object)actualValue);
        }
        for (Map.Entry entry : keyAndValues.entrySet()) {
            nearCacheTestContext2.nearCacheAdapter.remove(entry.getKey());
        }
        ((LifecycleServiceImpl)instanceToShutdown.getLifecycleService()).fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
        for (Map.Entry entry : keyAndValues.entrySet()) {
            key = (String)entry.getKey();
            ClientNearCacheInvalidationTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertNull((Object)ClientNearCacheInvalidationTest.getFromNearCache(nearCacheTestContext1, key));
                }
            });
        }
    }

    @Test
    public void putToCacheAndDoNotInvalidateFromClientNearCacheWhenPerEntryInvalidationIsDisabled() {
        int i;
        int i2;
        String cacheName = "disabledPerEntryInvalidationCache";
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(this.inMemoryFormat).setName(cacheName).setInvalidateOnChange(true);
        CacheConfig cacheConfig = this.createCacheConfig(this.inMemoryFormat);
        cacheConfig.setName(cacheName);
        cacheConfig.setDisablePerEntryInvalidationEvents(true);
        NearCacheTestContext nearCacheTestContext1 = this.createNearCacheTest(cacheName, nearCacheConfig, cacheConfig);
        final NearCacheTestContext nearCacheTestContext2 = this.createNearCacheTest(cacheName, nearCacheConfig, cacheConfig);
        for (i2 = 0; i2 < 1000; ++i2) {
            nearCacheTestContext1.nearCacheAdapter.put((Object)i2, (Object)ClientNearCacheTestSupport.generateValueFromKey(i2));
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            final Integer key = i2;
            final String value = (String)nearCacheTestContext2.nearCacheAdapter.get((Object)key);
            ClientNearCacheInvalidationTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertEquals((Object)value, (Object)ClientNearCacheInvalidationTest.getFromNearCache(nearCacheTestContext2, key));
                }
            });
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            nearCacheTestContext1.nearCacheAdapter.put((Object)i2, (Object)ClientNearCacheTestSupport.generateValueFromKey(i2 + 1000));
        }
        int invalidationEventFlushFreq = Integer.parseInt(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getDefaultValue());
        ClientNearCacheInvalidationTest.sleepSeconds((int)(2 * invalidationEventFlushFreq));
        for (i = 0; i < 1000; ++i) {
            String actualValue = (String)nearCacheTestContext2.nearCacheAdapter.get((Object)i);
            String expectedValue = ClientNearCacheTestSupport.generateValueFromKey(i);
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        }
        nearCacheTestContext1.nearCacheAdapter.clear();
        i = 0;
        while (i < 1000) {
            final int key = i++;
            ClientNearCacheInvalidationTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertNull((Object)ClientNearCacheInvalidationTest.getFromNearCache(nearCacheTestContext2, key));
                }
            });
        }
    }

    @Test
    public void when_shuttingDown_invalidationEventIsNotReceived() {
        this.populateMemberCache();
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.dataInstance.shutdown();
        } else {
            this.testContext.nearCacheInstance.shutdown();
        }
        this.assertNoFurtherInvalidation();
    }

    @Test
    public void when_cacheDestroyed_invalidationEventIsReceived() {
        this.populateMemberCache();
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.dataAdapter.destroy();
        } else {
            this.testContext.nearCacheAdapter.destroy();
        }
        this.assertLeastInvalidationCount(1);
    }

    @Test
    public void when_cacheCleared_invalidationEventIsReceived() {
        this.populateMemberCache();
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.dataAdapter.clear();
        } else {
            this.testContext.nearCacheAdapter.clear();
        }
        this.assertNoFurtherInvalidationThan(1);
    }

    @Test
    public void when_cacheClosed_invalidationEventIsNotReceived() {
        this.populateMemberCache();
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.dataAdapter.close();
        } else {
            this.testContext.nearCacheAdapter.close();
        }
        this.assertNoFurtherInvalidation();
    }

    @Test
    public void when_cacheManagerDestroyCacheInvoked_invalidationEventMayBeReceived() {
        this.populateMemberCache();
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.memberCacheManager.destroyCache(DEFAULT_CACHE_NAME);
        } else {
            this.testContext.cacheManager.destroyCache(DEFAULT_CACHE_NAME);
        }
        this.assertLeastInvalidationCount(1);
    }

    private <K, V, NK, NV> NearCacheTestContext<K, V, NK, NV> createNearCacheTest(String cacheName, NearCacheConfig nearCacheConfig, CacheConfig<K, V> cacheConfig) {
        ClientConfig clientConfig = this.createClientConfig().addNearCacheConfig(nearCacheConfig);
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        ICache cache = cacheManager.createCache(cacheName, cacheConfig);
        NearCache nearCache = nearCacheManager.getNearCache(cacheManager.getCacheNameWithPrefix(cacheName));
        NearCacheInvalidationListener invalidationListener = ClientCacheInvalidationListener.createInvalidationEventHandler(cache);
        NearCacheTestContextBuilder builder = new NearCacheTestContextBuilder(nearCacheConfig, client.getSerializationService());
        return builder.setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new ICacheDataStructureAdapter(cache)).setNearCacheManager(nearCacheManager).setNearCache(nearCache).setInvalidationListener(invalidationListener).build();
    }

    private void waitEndOfInvalidationsFromInitialPopulation() {
        ClientNearCacheInvalidationTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                long invalidationCount = ((ClientNearCacheInvalidationTest)ClientNearCacheInvalidationTest.this).testContext.invalidationListener.getInvalidationCount();
                Assert.assertEquals((long)1000L, (long)invalidationCount);
                ((ClientNearCacheInvalidationTest)ClientNearCacheInvalidationTest.this).testContext.invalidationListener.resetInvalidationCount();
            }
        });
    }

    private void assertNoFurtherInvalidation() {
        this.assertNoFurtherInvalidationThan(0);
    }

    private void assertNoFurtherInvalidationThan(final int expectedInvalidationCount) {
        AssertTask assertTask = new AssertTask(){

            public void run() throws Exception {
                long invalidationCount = ((ClientNearCacheInvalidationTest)ClientNearCacheInvalidationTest.this).testContext.invalidationListener.getInvalidationCount();
                Assert.assertEquals((long)expectedInvalidationCount, (long)invalidationCount);
            }
        };
        ClientNearCacheInvalidationTest.assertTrueEventually((AssertTask)assertTask);
        ClientNearCacheInvalidationTest.assertTrueAllTheTime((AssertTask)assertTask, (long)10L);
        this.testContext.invalidationListener.resetInvalidationCount();
    }

    private void assertLeastInvalidationCount(final int leastInvalidationCount) {
        AssertTask assertTask = new AssertTask(){

            public void run() throws Exception {
                long invalidationCount = ((ClientNearCacheInvalidationTest)ClientNearCacheInvalidationTest.this).testContext.invalidationListener.getInvalidationCount();
                Assert.assertTrue((String)String.format("invalidationCount is %d, but should be >= %d", invalidationCount, leastInvalidationCount), (invalidationCount >= (long)leastInvalidationCount ? 1 : 0) != 0);
            }
        };
        ClientNearCacheInvalidationTest.assertTrueEventually((AssertTask)assertTask);
        ClientNearCacheInvalidationTest.assertTrueAllTheTime((AssertTask)assertTask, (long)10L);
        this.testContext.invalidationListener.resetInvalidationCount();
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig();
    }

    protected NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat) {
        return new NearCacheConfig().setInMemoryFormat(inMemoryFormat).setName(DEFAULT_CACHE_NAME);
    }

    protected <K, V> CacheConfig<K, V> createCacheConfig(InMemoryFormat inMemoryFormat) {
        return new CacheConfig().setName(DEFAULT_CACHE_NAME).setInMemoryFormat(inMemoryFormat).setBackupCount(1);
    }

    private void populateMemberCache() {
        for (int i = 0; i < 1000; ++i) {
            this.testContext.dataAdapter.put((Object)i, (Object)Integer.toString(i));
        }
        this.waitEndOfInvalidationsFromInitialPopulation();
    }

    private static <K, V, NK, NV> NV getFromNearCache(NearCacheTestContext<K, V, NK, NV> nearCacheTestContext, Object key) {
        if (nearCacheTestContext.nearCache.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            key = nearCacheTestContext.serializationService.toData(key);
        }
        return (NV)nearCacheTestContext.nearCache.get(key);
    }
}

