/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.cache.impl.nearcache.ClientNearCacheTestSupport;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.NearCacheRecordStore;
import com.hazelcast.internal.nearcache.impl.DefaultNearCache;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataContainer;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.internal.nearcache.impl.invalidation.StaleReadDetector;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParallelParametersRunnerFactory.class)
@Category(value={NightlyTest.class})
public class InvalidationMemberAddRemoveTest
extends ClientNearCacheTestSupport {
    private static final int TEST_RUN_SECONDS = 30;
    private static final int KEY_COUNT = 1000;
    private static final int INVALIDATION_BATCH_SIZE = 100;
    private static final int RECONCILIATION_INTERVAL_SECS = 30;
    private static final int NEAR_CACHE_POPULATE_THREAD_COUNT = 5;
    private HazelcastInstance secondNode;
    @Parameterized.Parameter
    public NearCacheConfig.LocalUpdatePolicy localUpdatePolicy;

    @Parameterized.Parameters(name="localUpdatePolicy:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{NearCacheConfig.LocalUpdatePolicy.INVALIDATE}});
    }

    @Test
    public void ensure_nearCachedClient_and_member_data_sync_eventually() {
        final AtomicBoolean stopTest = new AtomicBoolean();
        final Config config = this.createConfig();
        this.secondNode = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)this.serverInstance);
        CacheManager serverCacheManager = provider.getCacheManager();
        final Cache memberCache = serverCacheManager.createCache("ClientCache", this.createCacheConfig(InMemoryFormat.BINARY));
        for (int i = 0; i < 1000; ++i) {
            memberCache.put((Object)i, (Object)i);
        }
        ClientConfig clientConfig = this.createClientConfig().addNearCacheConfig(this.createNearCacheConfig(InMemoryFormat.BINARY));
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        final Cache clientCache = clientCachingProvider.getCacheManager().createCache("ClientCache", this.createCacheConfig(InMemoryFormat.BINARY));
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Thread shadowMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    HazelcastInstance member = InvalidationMemberAddRemoveTest.this.hazelcastFactory.newHazelcastInstance(config);
                    HazelcastTestSupport.sleepSeconds((int)5);
                    member.getLifecycleService().terminate();
                }
            }
        });
        threads.add(shadowMember);
        for (int i = 0; i < 5; ++i) {
            Thread populateClientNearCache = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!stopTest.get()) {
                        for (int i = 0; i < 1000; ++i) {
                            clientCache.get((Object)i);
                        }
                    }
                }
            });
            threads.add(populateClientNearCache);
        }
        Thread putFromMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    int key = RandomPicker.getInt((int)1000);
                    int value = RandomPicker.getInt((int)Integer.MAX_VALUE);
                    memberCache.put((Object)key, (Object)value);
                    HazelcastTestSupport.sleepAtLeastMillis((long)2L);
                }
            }
        });
        threads.add(putFromMember);
        Thread clearFromMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    memberCache.clear();
                    HazelcastTestSupport.sleepSeconds((int)3);
                }
            }
        });
        threads.add(clearFromMember);
        for (Thread thread : threads) {
            thread.start();
        }
        InvalidationMemberAddRemoveTest.sleepSeconds((int)30);
        stopTest.set(true);
        for (Thread thread : threads) {
            InvalidationMemberAddRemoveTest.assertJoinable((Thread[])new Thread[]{thread});
        }
        InvalidationMemberAddRemoveTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                for (int i = 0; i < 1000; ++i) {
                    Integer valueSeenFromMember = (Integer)memberCache.get((Object)i);
                    Integer valueSeenFromClient = (Integer)clientCache.get((Object)i);
                    String msg = this.createFailureMessage(i);
                    Assert.assertEquals((String)msg, (Object)valueSeenFromMember, (Object)valueSeenFromClient);
                }
            }

            private String createFailureMessage(int i) {
                int partitionId = HazelcastTestSupport.getPartitionService((HazelcastInstance)InvalidationMemberAddRemoveTest.this.serverInstance).getPartitionId((Object)i);
                NearCacheRecordStore nearCacheRecordStore = this.getNearCacheRecordStore();
                NearCacheRecord record = nearCacheRecordStore.getRecord((Object)i);
                long recordSequence = record == null ? -1L : record.getInvalidationSequence();
                MetaDataGenerator metaDataGenerator1 = this.getMetaDataGenerator(InvalidationMemberAddRemoveTest.this.serverInstance);
                long memberSequence1 = metaDataGenerator1.currentSequence("/hz/ClientCache", partitionId);
                UUID memberUuid1 = metaDataGenerator1.getUuidOrNull(partitionId);
                MetaDataGenerator metaDataGenerator2 = this.getMetaDataGenerator(InvalidationMemberAddRemoveTest.this.secondNode);
                long memberSequence2 = metaDataGenerator2.currentSequence("/hz/ClientCache", partitionId);
                UUID memberUuid2 = metaDataGenerator2.getUuidOrNull(partitionId);
                StaleReadDetector staleReadDetector = nearCacheRecordStore.getStaleReadDetector();
                MetaDataContainer metaDataContainer = staleReadDetector.getMetaDataContainer(partitionId);
                return String.format("On client: [uuid=%s, partition=%d, onRecordSequence=%d, latestSequence=%d, staleSequence=%d],%nOn members: [memberUuid1=%s, memberSequence1=%d, memberUuid2=%s, memberSequence2=%d]", metaDataContainer.getUuid(), partitionId, recordSequence, metaDataContainer.getSequence(), metaDataContainer.getStaleSequence(), memberUuid1, memberSequence1, memberUuid2, memberSequence2);
            }

            private MetaDataGenerator getMetaDataGenerator(HazelcastInstance node) {
                CacheService service = (CacheService)HazelcastTestSupport.getNodeEngineImpl((HazelcastInstance)node).getService("hz:impl:cacheService");
                CacheEventHandler cacheEventHandler = service.getCacheEventHandler();
                return cacheEventHandler.getMetaDataGenerator();
            }

            private NearCacheRecordStore getNearCacheRecordStore() {
                NearCache nearCache = ((NearCachedClientCacheProxy)clientCache).getNearCache();
                DefaultNearCache defaultNearCache = (DefaultNearCache)nearCache.unwrap(DefaultNearCache.class);
                return defaultNearCache.getNearCacheRecordStore();
            }
        });
    }

    @Override
    protected Config createConfig() {
        return super.createConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "271").setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true").setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(100));
    }

    @Override
    protected ClientConfig createClientConfig() {
        return new ClientConfig().setProperty(RepairingTask.MAX_TOLERATED_MISS_COUNT.getName(), "0").setProperty(RepairingTask.RECONCILIATION_INTERVAL_SECONDS.getName(), String.valueOf(30));
    }

    protected CacheConfig<Integer, Integer> createCacheConfig(InMemoryFormat inMemoryFormat) {
        EvictionConfig evictionConfig = new EvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return super.createCacheConfig(inMemoryFormat).setEvictionConfig(evictionConfig);
    }

    @Override
    protected NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat) {
        EvictionConfig evictionConfig = new EvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return super.createNearCacheConfig(inMemoryFormat).setInvalidateOnChange(true).setLocalUpdatePolicy(this.localUpdatePolicy).setEvictionConfig(evictionConfig);
    }
}

