/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.nearcache.ClientNearCacheTestSupport;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import com.hazelcast.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class InvalidationMetadataDistortionTest
extends ClientNearCacheTestSupport {
    @Override
    protected Config createConfig() {
        Config config = super.createConfig();
        config.setProperty(GroupProperty.PARTITION_COUNT.getName(), "271");
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true");
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), "10");
        return config;
    }

    @Override
    protected ClientConfig createClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.invalidation.max.tolerated.miss.count", "0");
        return clientConfig;
    }

    @Override
    protected CacheConfig createCacheConfig(InMemoryFormat inMemoryFormat) {
        CacheConfig cacheConfig = super.createCacheConfig(inMemoryFormat);
        cacheConfig.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return cacheConfig;
    }

    @Override
    protected NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat) {
        NearCacheConfig nearCacheConfig = super.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setInvalidateOnChange(true).getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return nearCacheConfig;
    }

    @Test
    public void ensure_nearCachedClient_and_member_data_sync_eventually() throws Exception {
        int cacheSize = 100000;
        final AtomicBoolean stopTest = new AtomicBoolean();
        Config config = this.createConfig();
        final HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)this.serverInstance);
        CacheManager serverCacheManager = provider.getCacheManager();
        final Cache memberCache = serverCacheManager.createCache("ClientCache", (Configuration)this.createCacheConfig(InMemoryFormat.BINARY));
        for (int i = 0; i < 100000; ++i) {
            memberCache.put((Object)i, (Object)i);
        }
        ClientConfig clientConfig = this.createClientConfig();
        clientConfig.addNearCacheConfig(this.createNearCacheConfig(InMemoryFormat.BINARY));
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        final Cache clientCache = clientCachingProvider.getCacheManager().createCache("ClientCache", (Configuration)this.createCacheConfig(InMemoryFormat.BINARY));
        Thread populateNearCache = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    for (int i = 0; i < 100000; ++i) {
                        clientCache.get((Object)i);
                    }
                }
            }
        });
        Thread distortSequence = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    InvalidationMetadataDistortionTest.this.distortRandomPartitionSequence("ClientCache", member);
                    HazelcastTestSupport.sleepSeconds((int)1);
                }
            }
        });
        Thread distortUuid = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    InvalidationMetadataDistortionTest.this.distortRandomPartitionUuid(member);
                    HazelcastTestSupport.sleepSeconds((int)5);
                }
            }
        });
        Thread put = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    int key = RandomPicker.getInt((int)100000);
                    int value = RandomPicker.getInt((int)Integer.MAX_VALUE);
                    memberCache.put((Object)key, (Object)value);
                    HazelcastTestSupport.sleepAtLeastMillis((long)100L);
                }
            }
        });
        put.start();
        populateNearCache.start();
        distortSequence.start();
        distortUuid.start();
        InvalidationMetadataDistortionTest.sleepSeconds((int)60);
        stopTest.set(true);
        distortUuid.join();
        distortSequence.join();
        populateNearCache.join();
        put.join();
        InvalidationMetadataDistortionTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                for (int i = 0; i < 100000; ++i) {
                    Integer valueSeenFromMember = (Integer)memberCache.get((Object)i);
                    Integer valueSeenFromClient = (Integer)clientCache.get((Object)i);
                    Assert.assertEquals((Object)valueSeenFromMember, (Object)valueSeenFromClient);
                }
            }
        });
    }

    private void distortRandomPartitionSequence(String mapName, HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = InvalidationMetadataDistortionTest.getNodeEngineImpl((HazelcastInstance)member);
        CacheService service = (CacheService)nodeEngineImpl.getService("hz:impl:cacheService");
        CacheEventHandler cacheEventHandler = service.getCacheEventHandler();
        MetaDataGenerator metaDataGenerator = cacheEventHandler.getMetaDataGenerator();
        InternalPartitionService partitionService = nodeEngineImpl.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        int randomPartition = RandomPicker.getInt((int)partitionCount);
        int randomSequence = RandomPicker.getInt((int)Integer.MAX_VALUE);
        metaDataGenerator.setCurrentSequence(mapName, randomPartition, (long)randomSequence);
    }

    private void distortRandomPartitionUuid(HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = InvalidationMetadataDistortionTest.getNodeEngineImpl((HazelcastInstance)member);
        int partitionCount = nodeEngineImpl.getPartitionService().getPartitionCount();
        CacheService service = (CacheService)nodeEngineImpl.getService("hz:impl:cacheService");
        CacheEventHandler cacheEventHandler = service.getCacheEventHandler();
        MetaDataGenerator metaDataGenerator = cacheEventHandler.getMetaDataGenerator();
        UUID uuid = UuidUtil.newUnsecureUUID();
        int randomPartition = RandomPicker.getInt((int)partitionCount);
        metaDataGenerator.setUuid(randomPartition, uuid);
    }

    protected HazelcastClientInstanceImpl getHazelcastClientInstanceImpl(HazelcastInstance client) {
        HazelcastClientProxy clientProxy = (HazelcastClientProxy)client;
        return clientProxy.client;
    }
}

