/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cluster;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.cluster.impl.AdvancedClusterStateTest;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientClusterStateTest {
    private TestHazelcastFactory factory;
    private HazelcastInstance[] instances;
    private HazelcastInstance instance;

    @Before
    public void before() {
        this.factory = new TestHazelcastFactory();
        for (HazelcastInstance instance : this.instances = this.factory.newInstances(new Config(), 4)) {
            HazelcastTestSupport.assertClusterSizeEventually((int)4, (HazelcastInstance[])new HazelcastInstance[]{instance});
        }
        this.instance = this.instances[this.instances.length - 1];
    }

    @After
    public void after() {
        this.factory.terminateAll();
    }

    @Test
    public void testClient_canConnect_whenClusterState_frozen() {
        this.instance.getCluster().changeClusterState(ClusterState.FROZEN);
        this.factory.newHazelcastClient();
    }

    @Test
    public void testClient_canExecuteWriteOperations_whenClusterState_frozen() {
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])this.instances);
        AdvancedClusterStateTest.changeClusterStateEventually((HazelcastInstance)this.instance, (ClusterState)ClusterState.FROZEN);
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(HazelcastTestSupport.randomMapName());
        map.put((Object)1, (Object)1);
    }

    @Test
    public void testClient_canExecuteReadOperations_whenClusterState_frozen() {
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])this.instances);
        AdvancedClusterStateTest.changeClusterStateEventually((HazelcastInstance)this.instance, (ClusterState)ClusterState.FROZEN);
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(HazelcastTestSupport.randomMapName());
        map.get((Object)1);
    }

    @Test
    public void testClient_canConnect_whenClusterState_passive() {
        this.instance.getCluster().changeClusterState(ClusterState.PASSIVE);
        this.factory.newHazelcastClient();
    }

    @Test(expected=OperationTimeoutException.class)
    public void testClient_canNotExecuteWriteOperations_whenClusterState_passive() {
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])this.instances);
        ClientConfig clientConfig = new ClientConfig().setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "3");
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(HazelcastTestSupport.randomMapName());
        AdvancedClusterStateTest.changeClusterStateEventually((HazelcastInstance)this.instance, (ClusterState)ClusterState.PASSIVE);
        map.put((Object)1, (Object)1);
    }

    @Test
    public void testClient_canExecuteReadOperations_whenClusterState_passive() {
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])this.instances);
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(HazelcastTestSupport.randomMapName());
        AdvancedClusterStateTest.changeClusterStateEventually((HazelcastInstance)this.instance, (ClusterState)ClusterState.PASSIVE);
        map.get((Object)1);
    }

    @Test
    public void testClient_canConnect_whenClusterState_goesBackToActive_fromPassive() {
        this.instance.getCluster().changeClusterState(ClusterState.PASSIVE);
        this.instance.getCluster().changeClusterState(ClusterState.ACTIVE);
        this.factory.newHazelcastClient();
    }

    @Test
    public void testClient_canExecuteOperations_whenClusterState_goesBackToActive_fromPassive() {
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])this.instances);
        AdvancedClusterStateTest.changeClusterStateEventually((HazelcastInstance)this.instance, (ClusterState)ClusterState.PASSIVE);
        this.instance.getCluster().changeClusterState(ClusterState.ACTIVE);
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(HazelcastTestSupport.randomMapName());
        map.put((Object)1, (Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterShutdownDuringMapPutAll() {
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])this.instances);
        HazelcastTestSupport.waitAllForSafeState((HazelcastInstance[])this.instances);
        HazelcastInstance client = this.factory.newHazelcastClient();
        final IMap map = client.getMap(HazelcastTestSupport.randomMapName());
        final HashMap<Double, Double> values = new HashMap<Double, Double>();
        for (int i = 0; i < 1000; ++i) {
            double value = Math.random();
            values.put(value, value);
        }
        int numThreads = 10;
        final CountDownLatch threadsFinished = new CountDownLatch(10);
        final CountDownLatch threadsStarted = new CountDownLatch(10);
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 0; i < 10; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ILogger logger = Logger.getLogger(this.getClass());
                    threadsStarted.countDown();
                    logger.info("putAll thread started");
                    while (true) {
                        try {
                            while (true) {
                                map.putAll((Map)values);
                                Thread.sleep(100L);
                            }
                        }
                        catch (IllegalStateException e) {
                            logger.warning("Expected exception for Map putAll during cluster shutdown:", (Throwable)e);
                        }
                        catch (TargetDisconnectedException e) {
                            logger.warning("Expected exception for Map putAll during cluster shutdown:", (Throwable)e);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    threadsFinished.countDown();
                    logger.info("putAll thread finishing. Current finished thread count is:" + (10L - threadsFinished.getCount()));
                }
            });
        }
        try {
            Assert.assertTrue((String)"All threads could not be started", (boolean)threadsStarted.await(1L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            Assert.fail((String)("All threads could not be started due to InterruptedException. Could not start " + threadsStarted.getCount() + " threads out of " + 10));
        }
        this.instance.getCluster().shutdown();
        executor.shutdown();
        try {
            Assert.assertTrue((String)"All threads could not be finished", (boolean)threadsFinished.await(2L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            Assert.fail((String)("All threads could not be finished due to InterruptedException. Could not finish " + threadsFinished.getCount() + " threads out of " + 10));
        }
        finally {
            executor.shutdownNow();
        }
    }
}

