/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.PortableFactory;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientConfigTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testAccessGroupNameOverClientInstance() {
        Config config = new Config();
        String groupName = "aGroupName";
        config.getGroupConfig().setName(groupName);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setName(groupName);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        Assert.assertEquals((Object)groupName, (Object)client.getConfig().getGroupConfig().getName());
    }

    @Test
    public void testAccessSerializationConfigOverClientInstance() {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().addPortableFactory(666, (com.hazelcast.nio.serialization.PortableFactory)new PortableFactory());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        SerializationConfig serializationConfig = client.getConfig().getSerializationConfig();
        Map factories = serializationConfig.getPortableFactories();
        Assert.assertEquals((long)1L, (long)factories.size());
        Assert.assertEquals((long)((com.hazelcast.nio.serialization.PortableFactory)factories.get(666)).create(2).getClassId(), (long)2L);
    }
}

