/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.instance.Node;
import com.hazelcast.spi.NodeAware;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.spi.serialization.SerializationServiceAware;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class HazelcastClientManagedContextTest
extends HazelcastTestSupport {
    private DependencyInjectionUserClass userClass;
    private DependencyInjectionUserManagedContext userContext;
    private TestHazelcastFactory factory;
    private HazelcastClientInstanceImpl client;
    private SerializationService serializationService;

    @Before
    public void setUp() {
        this.userClass = new DependencyInjectionUserClass();
        this.userContext = new DependencyInjectionUserManagedContext();
        ClientConfig config = new ClientConfig().setManagedContext((ManagedContext)this.userContext);
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance();
        HazelcastInstance hzInstance = this.factory.newHazelcastClient(config);
        this.client = ClientTestUtil.getHazelcastClientInstanceImpl(hzInstance);
        this.serializationService = ClientTestUtil.getClientSerializationService(hzInstance);
    }

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test
    public void testInitialize() {
        this.serializationService.getManagedContext().initialize((Object)this.userClass);
        Assert.assertEquals((Object)this.client, (Object)this.userClass.hazelcastInstance);
        Assert.assertNull((String)"The client doesn't inject the Node", (Object)this.userClass.node);
        Assert.assertEquals((Object)this.serializationService, (Object)this.userClass.serializationService);
        Assert.assertTrue((boolean)this.userContext.wasCalled);
    }

    private static class DependencyInjectionUserManagedContext
    implements ManagedContext {
        private boolean wasCalled;

        private DependencyInjectionUserManagedContext() {
        }

        public Object initialize(Object obj) {
            this.wasCalled = true;
            return obj;
        }
    }

    private static class DependencyInjectionUserClass
    implements HazelcastInstanceAware,
    NodeAware,
    SerializationServiceAware {
        private HazelcastInstance hazelcastInstance;
        private Node node;
        private SerializationService serializationService;

        private DependencyInjectionUserClass() {
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public void setSerializationService(SerializationService serializationService) {
            this.serializationService = serializationService;
        }
    }
}

