/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.TestEventCollectingMapPartitionLostListener;
import com.hazelcast.map.impl.MapPartitionLostEventFilter;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.impl.proxyservice.InternalProxyService;
import com.hazelcast.spi.partition.IPartitionLostEvent;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapPartitionLostListenerTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void test_mapPartitionLostListener_registered() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig());
        String mapName = ClientMapPartitionLostListenerTest.randomMapName();
        client.getMap(mapName).addPartitionLostListener((MapPartitionLostListener)Mockito.mock(MapPartitionLostListener.class));
        ClientMapPartitionLostListenerTest.assertRegistrationEventually(instance, mapName, true);
    }

    @Test
    public void test_mapPartitionLostListener_removed() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig());
        String mapName = ClientMapPartitionLostListenerTest.randomMapName();
        String registrationId = client.getMap(mapName).addPartitionLostListener((MapPartitionLostListener)Mockito.mock(MapPartitionLostListener.class));
        ClientMapPartitionLostListenerTest.assertRegistrationEventually(instance, mapName, true);
        Assert.assertTrue((boolean)client.getMap(mapName).removePartitionLostListener(registrationId));
        ClientMapPartitionLostListenerTest.assertRegistrationEventually(instance, mapName, false);
    }

    @Test
    public void test_mapPartitionLostListener_invoked() {
        String mapName = ClientMapPartitionLostListenerTest.randomMapName();
        Config config = this.getConfig();
        config.getMapConfig(mapName).setBackupCount(0);
        ClientConfig clientConfig = this.getClientConfig();
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        ClientMapPartitionLostListenerTest.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{instance, client});
        TestEventCollectingMapPartitionLostListener listener = new TestEventCollectingMapPartitionLostListener(0);
        client.getMap(mapName).addPartitionLostListener((MapPartitionLostListener)listener);
        MapService mapService = (MapService)ClientMapPartitionLostListenerTest.getNode((HazelcastInstance)instance).getNodeEngine().getService("hz:impl:mapService");
        int partitionId = 5;
        mapService.onPartitionLost(new IPartitionLostEvent(partitionId, 0, null));
        ClientMapPartitionLostListenerTest.assertMapPartitionLostEventEventually(listener, partitionId);
    }

    @Test
    public void test_mapPartitionLostListener_invoked_fromOtherNode() {
        String mapName = ClientMapPartitionLostListenerTest.randomMapName();
        Config config = this.getConfig();
        config.getMapConfig(mapName).setBackupCount(0);
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = this.getClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(false);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientInstanceImpl clientInstanceImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        Address clientOwnerAddress = clientInstanceImpl.getConnectionManager().getOwnerConnectionAddress();
        HazelcastInstance other = ClientMapPartitionLostListenerTest.getAddress((HazelcastInstance)instance1).equals((Object)clientOwnerAddress) ? instance2 : instance1;
        TestEventCollectingMapPartitionLostListener listener = new TestEventCollectingMapPartitionLostListener(0);
        client.getMap(mapName).addPartitionLostListener((MapPartitionLostListener)listener);
        ClientMapPartitionLostListenerTest.assertRegistrationEventually(instance1, mapName, true);
        ClientMapPartitionLostListenerTest.assertRegistrationEventually(instance2, mapName, true);
        ClientMapPartitionLostListenerTest.assertProxyExistsEventually(instance1, mapName);
        ClientMapPartitionLostListenerTest.assertProxyExistsEventually(instance2, mapName);
        MapService mapService = (MapService)ClientMapPartitionLostListenerTest.getNode((HazelcastInstance)other).getNodeEngine().getService("hz:impl:mapService");
        int partitionId = 5;
        mapService.onPartitionLost(new IPartitionLostEvent(partitionId, 0, null));
        ClientMapPartitionLostListenerTest.assertMapPartitionLostEventEventually(listener, partitionId);
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private static void assertMapPartitionLostEventEventually(final TestEventCollectingMapPartitionLostListener listener, final int partitionId) {
        ClientMapPartitionLostListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                List events = listener.getEvents();
                Assert.assertFalse((boolean)events.isEmpty());
                Assert.assertEquals((long)partitionId, (long)((MapPartitionLostEvent)events.get(0)).getPartitionId());
            }
        });
    }

    private static void assertProxyExistsEventually(HazelcastInstance instance, final String proxyName) {
        final InternalProxyService proxyService = ClientMapPartitionLostListenerTest.getNodeEngineImpl((HazelcastInstance)instance).getProxyService();
        ClientMapPartitionLostListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Collection allDistributedObjects = proxyService.getAllDistributedObjects();
                for (DistributedObject distributedObject : allDistributedObjects) {
                    if (!distributedObject.getName().equals(proxyName)) continue;
                    return;
                }
                Assert.fail((String)("There is no proxy with name " + proxyName + " created (yet)"));
            }
        });
    }

    private static void assertRegistrationEventually(HazelcastInstance instance, final String mapName, final boolean shouldBeRegistered) {
        final InternalEventService eventService = ClientMapPartitionLostListenerTest.getNode((HazelcastInstance)instance).getNodeEngine().getEventService();
        ClientMapPartitionLostListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                boolean registered = false;
                for (EventRegistration registration : eventService.getRegistrations("hz:impl:mapService", mapName)) {
                    if (!(registration.getFilter() instanceof MapPartitionLostEventFilter)) continue;
                    registered = true;
                    break;
                }
                if (shouldBeRegistered != registered) {
                    Assert.fail((String)("shouldBeRegistered: " + shouldBeRegistered + " registered: " + registered));
                }
            }
        });
    }
}

