/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.query.impl.FalsePredicate;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapRemoveAllTest
extends HazelcastTestSupport {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final int MAP_SIZE = 1000;
    private static final int NODE_COUNT = 3;
    private TestHazelcastFactory factory;
    private HazelcastInstance client;

    @Before
    public void setUp() {
        this.factory = new TestHazelcastFactory();
        this.factory.newInstances(this.getConfig(), 3);
        this.client = this.factory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void throws_exception_whenPredicateNull() throws Exception {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("predicate cannot be null");
        IMap map = this.client.getMap("test");
        map.removeAll(null);
    }

    @Test
    public void removes_all_entries_whenPredicateTrue() throws Exception {
        IMap map = this.client.getMap("test");
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i);
        }
        map.removeAll((Predicate)TruePredicate.INSTANCE);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void removes_no_entries_whenPredicateFalse() throws Exception {
        IMap map = this.client.getMap("test");
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i);
        }
        map.removeAll((Predicate)FalsePredicate.INSTANCE);
        Assert.assertEquals((long)1000L, (long)map.size());
    }

    @Test
    public void removes_odd_keys_whenPredicateOdd() throws Exception {
        IMap map = this.client.getMap("test");
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i);
        }
        map.removeAll((Predicate)new OddFinderPredicate());
        Assert.assertEquals((long)500L, (long)map.size());
    }

    private static final class OddFinderPredicate
    implements Predicate<Integer, Integer> {
        private OddFinderPredicate() {
        }

        public boolean apply(Map.Entry<Integer, Integer> mapEntry) {
            return mapEntry.getKey() % 2 != 0;
        }
    }
}

