/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class LocalMapStatsUnderOnGoingClientUpdateTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();
    private HazelcastInstance member = this.factory.newHazelcastInstance();
    private HazelcastInstance client;
    private String mapName = "test";

    @Before
    public void setUp() throws Exception {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(100);
        this.client = this.factory.newHazelcastClient(clientConfig);
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void stats_generated_when_member_restarted_under_ongoing_client_update() throws Exception {
        IMap map = this.client.getMap(this.mapName);
        this.member.shutdown();
        this.member = this.factory.newHazelcastInstance();
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)2);
        MapService mapService = (MapService)LocalMapStatsUnderOnGoingClientUpdateTest.getNodeEngineImpl((HazelcastInstance)this.member).getService("hz:impl:mapService");
        Map stats = mapService.getStats();
        LocalMapStats localMapStats = (LocalMapStats)stats.get(this.mapName);
        Assert.assertNotNull((String)"there should be 1 LocalMapStats object", (Object)localMapStats);
        Assert.assertEquals((String)"Owned entry count should be 2", (long)2L, (long)localMapStats.getOwnedEntryCount());
    }
}

