/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.map.impl.nearcache.ClientMapInvalidationListener;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.DataStructureAdapterMethod;
import com.hazelcast.internal.adapter.DataStructureLoader;
import com.hazelcast.internal.adapter.IMapDataStructureAdapter;
import com.hazelcast.internal.adapter.IMapMapStore;
import com.hazelcast.internal.nearcache.AbstractNearCacheBasicTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.map.impl.nearcache.MapNearCacheBasicTest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapNearCacheBasicTest
extends AbstractNearCacheBasicTest<Data, String> {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void setUp() {
        this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)NearCacheConfig.DEFAULT_MEMORY_FORMAT, (boolean)false);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    protected void assumeThatMethodIsAvailable(DataStructureAdapterMethod method) {
        NearCacheTestUtils.assumeThatMethodIsAvailable(IMapDataStructureAdapter.class, (DataStructureAdapterMethod)method);
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(int size, boolean loaderEnabled) {
        IMapMapStore mapStore = loaderEnabled ? new IMapMapStore() : null;
        Config config = this.createConfig(mapStore);
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        IMap memberMap = member.getMap("defaultNearCache");
        IMapDataStructureAdapter dataAdapter = new IMapDataStructureAdapter(memberMap);
        dataAdapter.waitUntilLoaded();
        ClientMapNearCacheBasicTest.populateDataAdapter((DataStructureAdapter)dataAdapter, (int)size);
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder();
        return builder.setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).setLoader((DataStructureLoader)mapStore).build();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createNearCacheContext() {
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder();
        return builder.build();
    }

    protected Config createConfig(IMapMapStore mapStore) {
        Config config = this.getConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "5").setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), "1");
        MapNearCacheBasicTest.addMapStoreConfig((IMapMapStore)mapStore, (MapConfig)config.getMapConfig("defaultNearCache"));
        return config;
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig().addNearCacheConfig(this.nearCacheConfig);
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder() {
        ClientConfig clientConfig = this.createClientConfig();
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap clientMap = client.getMap("defaultNearCache");
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache("defaultNearCache");
        return new NearCacheTestContextBuilder(this.nearCacheConfig, client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new IMapDataStructureAdapter(clientMap)).setNearCache(nearCache).setNearCacheManager(nearCacheManager).setInvalidationListener(ClientMapInvalidationListener.createInvalidationEventHandler(clientMap));
    }
}

