/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={SlowTest.class})
public class ClientMapNearCachePreloaderStressTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void testDestroyAndCreateProxyWithNearCache() {
        int i;
        this.factory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addNearCacheConfig(this.getNearCacheConfig("test"));
        final HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        int createPutGetThreadCount = 2;
        int destroyThreadCount = 2;
        ExecutorService pool = Executors.newFixedThreadPool(createPutGetThreadCount + destroyThreadCount);
        final AtomicBoolean isRunning = new AtomicBoolean(true);
        final AtomicReference exception = new AtomicReference();
        for (i = 0; i < destroyThreadCount; ++i) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    while (isRunning.get()) {
                        for (DistributedObject distributedObject : client.getDistributedObjects()) {
                            distributedObject.destroy();
                        }
                    }
                }
            });
        }
        for (i = 0; i < createPutGetThreadCount; ++i) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (isRunning.get()) {
                            IMap map = client.getMap("test");
                            map.put((Object)1, (Object)1);
                            map.get((Object)1);
                        }
                    }
                    catch (Exception e) {
                        isRunning.set(false);
                        e.printStackTrace(System.out);
                        exception.set(e);
                    }
                }
            });
        }
        ClientMapNearCachePreloaderStressTest.sleepSeconds((int)5);
        isRunning.set(false);
        pool.shutdown();
        TestCase.assertNull(exception.get());
    }

    private NearCacheConfig getNearCacheConfig(String name) {
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        NearCachePreloaderConfig preloaderConfig = new NearCachePreloaderConfig();
        preloaderConfig.setStoreIntervalSeconds(1);
        preloaderConfig.setEnabled(true);
        nearCacheConfig.setPreloaderConfig(preloaderConfig);
        nearCacheConfig.setName(name);
        return nearCacheConfig;
    }
}

