/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.RandomPicker;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class NearCacheStatsStressTest
extends HazelcastTestSupport {
    private static final int KEY_SPACE = 1000;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private InternalSerializationService ss;
    private NearCache<Object, Object> nearCache;

    @Before
    public void setUp() throws Exception {
        HazelcastInstance server = this.factory.newHazelcastInstance();
        this.ss = NearCacheStatsStressTest.getSerializationService((HazelcastInstance)server);
        String mapName = "test";
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setName(mapName);
        nearCacheConfig.setInvalidateOnChange(true);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addNearCacheConfig(nearCacheConfig);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(mapName);
        this.nearCache = ((NearCachedClientMapProxy)map).getNearCache();
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void stress_stats_by_doing_put_and_remove() throws Exception {
        ExecutorService pool = Executors.newFixedThreadPool(2);
        pool.execute(new Put());
        pool.execute(new Remove());
        NearCacheStatsStressTest.sleepSeconds((int)3);
        this.stop.set(true);
        pool.shutdown();
        if (pool.awaitTermination(10L, TimeUnit.SECONDS)) {
            NearCacheStats nearCacheStats = this.nearCache.getNearCacheStats();
            long ownedEntryCount = nearCacheStats.getOwnedEntryCount();
            long memoryCost = nearCacheStats.getOwnedEntryMemoryCost();
            int size = this.nearCache.size();
            Assert.assertTrue((String)("ownedEntryCount=" + ownedEntryCount + ", size=" + size), (ownedEntryCount >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)("memoryCost=" + memoryCost + ", size=" + size), (memoryCost >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((String)("ownedEntryCount=" + ownedEntryCount + ", size=" + size), (long)size, (long)ownedEntryCount);
        } else {
            Assert.fail((String)"pool.awaitTermination reached timeout before termination");
        }
    }

    class Remove
    implements Runnable {
        Remove() {
        }

        @Override
        public void run() {
            while (!NearCacheStatsStressTest.this.stop.get()) {
                Integer key = RandomPicker.getInt((int)1000);
                NearCacheStatsStressTest.this.nearCache.remove((Object)key);
            }
        }
    }

    class Put
    implements Runnable {
        Put() {
        }

        @Override
        public void run() {
            while (!NearCacheStatsStressTest.this.stop.get()) {
                Integer key = RandomPicker.getInt((int)1000);
                Data keyData = NearCacheStatsStressTest.this.ss.toData((Object)key);
                long reservationId = NearCacheStatsStressTest.this.nearCache.tryReserveForUpdate((Object)key, keyData);
                if (reservationId == -1L) continue;
                NearCacheStatsStressTest.this.nearCache.tryPublishReserved((Object)key, (Object)keyData, reservationId, false);
            }
        }
    }
}

