/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache.invalidation;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.impl.nearcache.invalidation.MemberMapReconciliationTest;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapReconciliationTest
extends HazelcastTestSupport {
    private static final String MAP_NAME = "test";
    private static final int RECONCILIATION_INTERVAL_SECONDS = 3;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private final ClientConfig clientConfig = new ClientConfig();
    private IMap serverMap;
    private IMap clientMap;

    @Before
    public void setUp() throws Exception {
        NearCacheConfig nearCacheConfig = new NearCacheConfig(MAP_NAME);
        nearCacheConfig.setInvalidateOnChange(true);
        this.clientConfig.setProperty("hazelcast.invalidation.max.tolerated.miss.count", "0");
        this.clientConfig.setProperty("hazelcast.invalidation.reconciliation.interval.seconds", String.valueOf(3));
        this.clientConfig.setProperty("hazelcast.invalidation.min.reconciliation.interval.seconds", String.valueOf(3));
        this.clientConfig.addNearCacheConfig(nearCacheConfig);
        Config config = new Config();
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.serverMap = server.getMap(MAP_NAME);
        this.clientMap = this.createMapFromNewClient();
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    private IMap createMapFromNewClient() {
        HazelcastInstance client = this.factory.newHazelcastClient(this.clientConfig);
        IMap map = client.getMap(MAP_NAME);
        assert (map instanceof NearCachedClientMapProxy);
        return map;
    }

    @Test
    public void test_reconciliation_does_not_cause_premature_removal() throws Exception {
        int i;
        int total = 100;
        for (i = 0; i < total; ++i) {
            this.serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < total; ++i) {
            this.clientMap.get((Object)i);
        }
        IMap mapFromNewClient = this.createMapFromNewClient();
        for (int i2 = 0; i2 < total; ++i2) {
            mapFromNewClient.get((Object)i2);
        }
        NearCacheStats nearCacheStats = mapFromNewClient.getLocalMapStats().getNearCacheStats();
        MemberMapReconciliationTest.assertStats((NearCacheStats)nearCacheStats, (int)total, (int)0, (int)total);
        ClientMapReconciliationTest.sleepSeconds((int)6);
        for (int i3 = 0; i3 < total; ++i3) {
            mapFromNewClient.get((Object)i3);
        }
        MemberMapReconciliationTest.assertStats((NearCacheStats)nearCacheStats, (int)total, (int)total, (int)total);
    }
}

