/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache.invalidation;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.map.impl.nearcache.NearCacheTestSupport;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class InvalidationMemberAddRemoveTest
extends NearCacheTestSupport {
    private static final int TEST_RUN_SECONDS = 30;
    private static final int KEY_COUNT = 1000;
    private static final int INVALIDATION_BATCH_SIZE = 100;
    private static final int RECONCILIATION_INTERVAL_SECS = 30;
    private static final int NEAR_CACHE_POPULATE_THREAD_COUNT = 5;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void ensure_nearCachedClient_and_member_data_sync_eventually() {
        String mapName = "ClientMapInvalidationMemberAddRemoveTest";
        final AtomicBoolean stopTest = new AtomicBoolean();
        final Config config = this.createConfig();
        HazelcastInstance member = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        final IMap memberMap = member.getMap("ClientMapInvalidationMemberAddRemoveTest");
        for (int i = 0; i < 1000; ++i) {
            memberMap.put((Object)i, (Object)i);
        }
        ClientConfig clientConfig = this.createClientConfig().addNearCacheConfig(this.createNearCacheConfig("ClientMapInvalidationMemberAddRemoveTest"));
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        final IMap clientMap = client.getMap("ClientMapInvalidationMemberAddRemoveTest");
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Thread shadowMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    HazelcastInstance member = InvalidationMemberAddRemoveTest.this.factory.newHazelcastInstance(config);
                    HazelcastTestSupport.sleepSeconds((int)5);
                    member.getLifecycleService().terminate();
                }
            }
        });
        threads.add(shadowMember);
        for (int i = 0; i < 5; ++i) {
            Thread populateClientNearCache = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!stopTest.get()) {
                        for (int i = 0; i < 1000; ++i) {
                            clientMap.get((Object)i);
                        }
                    }
                }
            });
            threads.add(populateClientNearCache);
        }
        Thread putFromMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    int key = RandomPicker.getInt((int)1000);
                    int value = RandomPicker.getInt((int)Integer.MAX_VALUE);
                    memberMap.put((Object)key, (Object)value);
                    HazelcastTestSupport.sleepAtLeastMillis((long)2L);
                }
            }
        });
        threads.add(putFromMember);
        Thread clearFromMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    memberMap.clear();
                    HazelcastTestSupport.sleepSeconds((int)5);
                }
            }
        });
        threads.add(clearFromMember);
        for (Thread thread : threads) {
            thread.start();
        }
        InvalidationMemberAddRemoveTest.sleepSeconds((int)30);
        stopTest.set(true);
        for (Thread thread : threads) {
            InvalidationMemberAddRemoveTest.assertJoinable((Thread[])new Thread[]{thread});
        }
        InvalidationMemberAddRemoveTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                for (int i = 0; i < 1000; ++i) {
                    Integer valueSeenFromMember = (Integer)memberMap.get((Object)i);
                    Integer valueSeenFromClient = (Integer)clientMap.get((Object)i);
                    int nearCacheSize = ((NearCachedClientMapProxy)clientMap).getNearCache().size();
                    Assert.assertEquals((String)("Stale value found. (nearCacheSize=" + nearCacheSize + ")"), (Object)valueSeenFromMember, (Object)valueSeenFromClient);
                }
            }
        });
    }

    protected Config createConfig() {
        return InvalidationMemberAddRemoveTest.smallInstanceConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "271").setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true").setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(100));
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig().setProperty(RepairingTask.MAX_TOLERATED_MISS_COUNT.getName(), "0").setProperty(RepairingTask.RECONCILIATION_INTERVAL_SECONDS.getName(), String.valueOf(30));
    }

    protected NearCacheConfig createNearCacheConfig(String mapName) {
        EvictionConfig evictionConfig = new EvictionConfig().setSize(Integer.MAX_VALUE).setEvictionPolicy(EvictionPolicy.NONE);
        return this.newNearCacheConfig().setName(mapName).setInvalidateOnChange(true).setEvictionConfig(evictionConfig);
    }
}

