/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.queue;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={SlowTest.class})
public class ClientDisruptionTest
extends HazelcastTestSupport {
    private static final int CLUSTER_SIZE = 3;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private List<HazelcastInstance> cluster;
    private HazelcastInstance client1;
    private HazelcastInstance client2;

    @Before
    public void setup() {
        this.cluster = new ArrayList<HazelcastInstance>(3);
        for (int i = 0; i < 3; ++i) {
            this.cluster.add(this.hazelcastFactory.newHazelcastInstance());
        }
        this.client1 = this.hazelcastFactory.newHazelcastClient();
        this.client2 = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void queueServerOfferClientsPoll_withNodeShutdown() throws InterruptedException {
        int initial = 2000;
        int max = 8000;
        for (int i = 0; i < 2000; ++i) {
            this.getNode(1).getQueue("Q1").offer((Object)i);
            this.getNode(2).getQueue("Q2").offer((Object)i);
        }
        int expectCount = 0;
        int i = 2000;
        while (i < 8000) {
            if (i == 4000) {
                this.shutdownNode(2);
            }
            final int index = i++;
            ClientDisruptionTest.assertExactlyOneSuccessfulRun((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertTrue((boolean)ClientDisruptionTest.this.getNode(1).getQueue("Q1").offer((Object)index));
                }
            });
            ClientDisruptionTest.assertExactlyOneSuccessfulRun((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertTrue((boolean)ClientDisruptionTest.this.getNode(3).getQueue("Q2").offer((Object)index));
                }
            });
            final int expected = expectCount++;
            ClientDisruptionTest.assertExactlyOneSuccessfulRun((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertEquals((Object)expected, (Object)ClientDisruptionTest.this.client1.getQueue("Q1").poll());
                }
            });
            ClientDisruptionTest.assertExactlyOneSuccessfulRun((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertEquals((Object)expected, (Object)ClientDisruptionTest.this.client2.getQueue("Q2").poll());
                }
            });
        }
        for (i = expectCount; i < 8000; ++i) {
            Assert.assertEquals((Object)i, (Object)this.client1.getQueue("Q1").poll());
            Assert.assertEquals((Object)i, (Object)this.client2.getQueue("Q2").poll());
        }
    }

    @Test
    public void mapServerPutClientsGet_withNodeShutdown() throws InterruptedException {
        int initial = 200;
        int max = 800;
        for (int i = 0; i < 200; ++i) {
            this.getNode(2).getMap("m").put((Object)i, (Object)i);
        }
        int expectCount = 0;
        int i = 200;
        while (i < 800) {
            if (i == 400) {
                this.shutdownNode(1);
            }
            final int index = i++;
            ClientDisruptionTest.assertExactlyOneSuccessfulRun((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertNull((Object)ClientDisruptionTest.this.getNode(2).getMap("m").put((Object)index, (Object)index));
                }
            });
            final int expected = expectCount++;
            ClientDisruptionTest.assertExactlyOneSuccessfulRun((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertEquals((Object)expected, (Object)ClientDisruptionTest.this.client1.getMap("m").get((Object)expected));
                }
            });
            ClientDisruptionTest.assertExactlyOneSuccessfulRun((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertEquals((Object)expected, (Object)ClientDisruptionTest.this.client2.getMap("m").get((Object)expected));
                }
            });
        }
        for (i = expectCount; i < 800; ++i) {
            Assert.assertEquals((Object)i, (Object)this.client1.getMap("m").get((Object)i));
        }
    }

    private HazelcastInstance getNode(int index) {
        return this.cluster.get(index - 1);
    }

    private void shutdownNode(int index) {
        HazelcastInstance node = this.getNode(index);
        node.getLifecycleService().shutdown();
    }
}

