/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.quorum;

import com.hazelcast.client.quorum.QuorumTestUtil;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.quorum.PartitionedCluster;

public class PartitionedClusterClients {
    private TestHazelcastFactory factory;
    private HazelcastInstance[] clients;
    private PartitionedCluster cluster;

    public PartitionedClusterClients(PartitionedCluster cluster, TestHazelcastFactory factory) {
        this.cluster = cluster;
        this.clients = new HazelcastInstance[cluster.instance.length];
        this.factory = factory;
    }

    public HazelcastInstance client(int index) {
        if (this.clients[index] == null) {
            this.clients[index] = QuorumTestUtil.createClient(this.factory, this.cluster.instance[index]);
        }
        return this.clients[index];
    }

    public void terminateAll() {
        for (HazelcastInstance client : this.clients) {
            if (client == null) continue;
            client.shutdown();
        }
    }
}

