/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.ReplicatedMapProxy;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.record.AbstractBaseReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.scheduler.SecondsBasedEntryTaskScheduler;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientReplicatedMapTest
extends HazelcastTestSupport {
    private static final int OPERATION_COUNT = 100;
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;
    private Config config = new Config();
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="format:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY}, {InMemoryFormat.OBJECT});
    }

    @Before
    public void setUp() {
        this.config.getReplicatedMapConfig("default").setInMemoryFormat(this.inMemoryFormat);
    }

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testEmptyMapIsEmpty() {
        this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(ClientReplicatedMapTest.randomName());
        Assert.assertTrue((String)"map should be empty", (boolean)map.isEmpty());
    }

    @Test
    public void testNonEmptyMapIsNotEmpty() {
        this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(ClientReplicatedMapTest.randomName());
        map.put((Object)1, (Object)1);
        Assert.assertFalse((String)"map should not be empty", (boolean)map.isEmpty());
    }

    @Test
    public void testPutAll() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = client.getReplicatedMap("default");
        ReplicatedMap map2 = server.getReplicatedMap("default");
        HashMap<String, String> mapTest = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            mapTest.put("foo-" + i, "bar");
        }
        map1.putAll(mapTest);
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
    }

    @Test
    public void testGet() {
        int i;
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)"bar", (Object)map1.get((Object)("foo-" + i)));
            Assert.assertEquals((Object)"bar", (Object)map2.get((Object)("foo-" + i)));
        }
    }

    @Test
    public void testPutNullReturnValueDeserialization() {
        this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(ClientReplicatedMapTest.randomMapName());
        Assert.assertNull((Object)map.put((Object)1, (Object)2));
    }

    @Test
    public void testPutReturnValueDeserialization() {
        this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(ClientReplicatedMapTest.randomMapName());
        map.put((Object)1, (Object)2);
        Assert.assertEquals((Object)2, (Object)map.put((Object)1, (Object)3));
    }

    @Test
    public void testAdd() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (int i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
    }

    @Test
    public void testClear() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (int i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        map1.clear();
        Assert.assertEquals((long)0L, (long)map1.size());
        Assert.assertEquals((long)0L, (long)map2.size());
    }

    @Test
    public void testUpdate() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (int i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (int i = 0; i < 100; ++i) {
            map2.put((Object)("foo-" + i), (Object)"bar2");
        }
        for (Map.Entry entry : map2.entrySet()) {
            Assert.assertEquals((Object)"bar2", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            Assert.assertEquals((Object)"bar2", entry.getValue());
        }
    }

    @Test
    public void testRemove() {
        int i;
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (int i2 = 0; i2 < 100; ++i2) {
            map1.put((Object)("foo-" + i2), (Object)"bar");
        }
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (i = 0; i < 100; ++i) {
            map2.remove((Object)("foo-" + i));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertNull((Object)map2.get((Object)("foo-" + i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertNull((Object)map1.get((Object)("foo-" + i)));
        }
    }

    @Test
    public void testSize() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = ClientReplicatedMapTest.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        Assert.assertEquals((long)testValues.length, (long)map1.size());
        Assert.assertEquals((long)testValues.length, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        int i;
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)map2.containsKey((Object)("foo-" + i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)map1.containsKey((Object)("foo-" + i)));
        }
    }

    @Test
    public void testContainsValue() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = ClientReplicatedMapTest.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        for (AbstractMap.SimpleEntry<Integer, Integer> testValue : testValues) {
            Assert.assertTrue((boolean)map2.containsValue((Object)testValue.getValue()));
        }
        for (AbstractMap.SimpleEntry<Integer, Integer> testValue : testValues) {
            Assert.assertTrue((boolean)map1.containsValue((Object)testValue.getValue()));
        }
    }

    @Test
    public void testValues() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = ClientReplicatedMapTest.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        HashSet values1 = new HashSet(map1.values());
        HashSet values2 = new HashSet(map2.values());
        for (AbstractMap.SimpleEntry<Integer, Integer> e : testValues) {
            ClientReplicatedMapTest.assertContains(values1, (Object)e.getValue());
            ClientReplicatedMapTest.assertContains(values2, (Object)e.getValue());
        }
    }

    @Test
    public void testKeySet() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = ClientReplicatedMapTest.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        HashSet keys1 = new HashSet(map1.keySet());
        HashSet keys2 = new HashSet(map2.keySet());
        for (AbstractMap.SimpleEntry<Integer, Integer> e : testValues) {
            ClientReplicatedMapTest.assertContains(keys1, (Object)e.getKey());
            ClientReplicatedMapTest.assertContains(keys2, (Object)e.getKey());
        }
    }

    @Test
    public void testEntrySet() {
        Integer value;
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = ClientReplicatedMapTest.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        HashSet entrySet1 = new HashSet(map1.entrySet());
        HashSet entrySet2 = new HashSet(map2.entrySet());
        for (Map.Entry entry : entrySet2) {
            value = ClientReplicatedMapTest.findValue((Integer)entry.getKey(), testValues);
            Assert.assertEquals((Object)value, entry.getValue());
        }
        for (Map.Entry entry : entrySet1) {
            value = ClientReplicatedMapTest.findValue((Integer)entry.getKey(), testValues);
            Assert.assertEquals((Object)value, entry.getValue());
        }
    }

    @Test
    public void testRetrieveUnknownValue() {
        this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = instance.getReplicatedMap("default");
        String value = (String)map.get((Object)"foo");
        Assert.assertNull((Object)value);
    }

    @Test
    public void testNearCacheInvalidation() {
        String mapName = ClientReplicatedMapTest.randomString();
        ClientConfig clientConfig = ClientReplicatedMapTest.getClientConfigWithNearCacheInvalidationEnabled();
        this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client1 = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastInstance client2 = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final ReplicatedMap replicatedMap1 = client1.getReplicatedMap(mapName);
        replicatedMap1.put((Object)1, (Object)1);
        replicatedMap1.get((Object)1);
        ReplicatedMap replicatedMap2 = client2.getReplicatedMap(mapName);
        replicatedMap2.put((Object)1, (Object)2);
        ClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)2L, (long)((Integer)replicatedMap1.get((Object)1)).intValue());
            }
        });
    }

    @Test
    public void testNearCacheInvalidation_withClear() {
        String mapName = ClientReplicatedMapTest.randomString();
        ClientConfig clientConfig = ClientReplicatedMapTest.getClientConfigWithNearCacheInvalidationEnabled();
        this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client1 = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastInstance client2 = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final ReplicatedMap replicatedMap1 = client1.getReplicatedMap(mapName);
        replicatedMap1.put((Object)1, (Object)1);
        replicatedMap1.get((Object)1);
        ReplicatedMap replicatedMap2 = client2.getReplicatedMap(mapName);
        replicatedMap2.clear();
        ClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertNull((Object)replicatedMap1.get((Object)1));
            }
        });
    }

    @Test
    public void testClientPortableWithoutRegisteringToNode() {
        if (this.inMemoryFormat == InMemoryFormat.OBJECT) {
            return;
        }
        SerializationConfig serializationConfig = new SerializationConfig().addPortableFactory(5, new PortableFactory(){

            public Portable create(int classId) {
                return new SamplePortable();
            }
        });
        ClientConfig clientConfig = new ClientConfig().setSerializationConfig(serializationConfig);
        this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        ReplicatedMap sampleMap = client.getReplicatedMap(ClientReplicatedMapTest.randomString());
        sampleMap.put((Object)1, (Object)new SamplePortable(666));
        SamplePortable samplePortable = (SamplePortable)sampleMap.get((Object)1);
        Assert.assertEquals((long)666L, (long)samplePortable.a);
    }

    @Test
    public void clear_empties_internal_ttl_schedulers() {
        String mapName = "test";
        HazelcastInstance node = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(mapName);
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i, 100L, TimeUnit.DAYS);
        }
        map.clear();
        ClientReplicatedMapTest.assertAllTtlSchedulersEmpty(node.getReplicatedMap(mapName));
    }

    @Test
    public void remove_empties_internal_ttl_schedulers() {
        int i;
        String mapName = "test";
        HazelcastInstance node = this.hazelcastFactory.newHazelcastInstance(this.config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(mapName);
        for (i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i, 100L, TimeUnit.DAYS);
        }
        for (i = 0; i < 1000; ++i) {
            map.remove((Object)i);
        }
        ClientReplicatedMapTest.assertAllTtlSchedulersEmpty(node.getReplicatedMap(mapName));
    }

    private static void assertAllTtlSchedulersEmpty(ReplicatedMap map) {
        String mapName = map.getName();
        ReplicatedMapProxy replicatedMapProxy = (ReplicatedMapProxy)map;
        ReplicatedMapService service = (ReplicatedMapService)replicatedMapProxy.getService();
        Collection stores = service.getAllReplicatedRecordStores(mapName);
        for (ReplicatedRecordStore store : stores) {
            Assert.assertEquals((long)0L, (long)((SecondsBasedEntryTaskScheduler)((AbstractBaseReplicatedRecordStore)store).getTtlEvictionScheduler()).size());
        }
    }

    private static AbstractMap.SimpleEntry<Integer, Integer>[] buildTestValues() {
        Random random = new Random();
        AbstractMap.SimpleEntry[] testValues = new AbstractMap.SimpleEntry[100];
        for (int i = 0; i < testValues.length; ++i) {
            testValues[i] = new AbstractMap.SimpleEntry<Integer, Integer>(random.nextInt(), random.nextInt());
        }
        return testValues;
    }

    private static Integer findValue(int key, AbstractMap.SimpleEntry<Integer, Integer>[] values) {
        for (AbstractMap.SimpleEntry<Integer, Integer> value : values) {
            if (!value.getKey().equals(key)) continue;
            return value.getValue();
        }
        return null;
    }

    private static ClientConfig getClientConfigWithNearCacheInvalidationEnabled() {
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setInvalidateOnChange(true).setInMemoryFormat(InMemoryFormat.OBJECT);
        return new ClientConfig().addNearCacheConfig(nearCacheConfig);
    }

    static class SamplePortable
    implements Portable {
        public int a;

        SamplePortable(int a) {
            this.a = a;
        }

        SamplePortable() {
        }

        public int getFactoryId() {
            return 5;
        }

        public int getClassId() {
            return 6;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeInt("a", this.a);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.a = reader.readInt("a");
        }
    }
}

