/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.replicatedmap.nearcache.ClientReplicatedMapInvalidationListener;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ReplicatedMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCacheLeakTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class})
public class ClientReplicatedMapNearCacheLeakTest
extends AbstractNearCacheLeakTest<Data, String> {
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="format:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY}, {InMemoryFormat.OBJECT});
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)this.inMemoryFormat, (boolean)true).setInvalidateOnChange(true);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(int size) {
        Config config = this.createConfig();
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        ReplicatedMap memberMap = member.getReplicatedMap("defaultNearCache");
        ReplicatedMapDataStructureAdapter dataAdapter = new ReplicatedMapDataStructureAdapter(memberMap);
        ClientReplicatedMapNearCacheLeakTest.populateDataAdapter((DataStructureAdapter)dataAdapter, (int)size);
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder();
        return builder.setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).build();
    }

    protected Config createConfig() {
        Config config = this.getConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "5");
        config.getReplicatedMapConfig("defaultNearCache").setInMemoryFormat(this.nearCacheConfig.getInMemoryFormat());
        return config;
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig().addNearCacheConfig(this.nearCacheConfig);
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder() {
        ClientConfig clientConfig = this.createClientConfig();
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        ReplicatedMap clientMap = client.getReplicatedMap("defaultNearCache");
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache("defaultNearCache");
        return new NearCacheTestContextBuilder(this.nearCacheConfig, client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new ReplicatedMapDataStructureAdapter(clientMap)).setNearCache(nearCache).setNearCacheManager(nearCacheManager).setInvalidationListener(ClientReplicatedMapInvalidationListener.createInvalidationEventHandler(clientMap));
    }
}

