/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.client.spi.impl.ClientProxyFactoryWithContext;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ProxyFactoryTest {
    private static final String SERVICE_NAME_WITH_CONTEXT = CustomServiceWithContext.class.getSimpleName();
    private static final String SERVICE_NAME = CustomService.class.getSimpleName();
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private ClientContext context;

    @Before
    public void setup() {
        ServiceConfig serviceConfigWithContext = new ServiceConfig().setEnabled(true).setName(SERVICE_NAME_WITH_CONTEXT).setImplementation((Object)new CustomServiceWithContext());
        ServiceConfig serviceConfig = new ServiceConfig().setEnabled(true).setName(SERVICE_NAME).setImplementation((Object)new CustomService());
        Config config = new Config();
        config.getServicesConfig().addServiceConfig(serviceConfigWithContext).addServiceConfig(serviceConfig);
        this.hazelcastFactory.newHazelcastInstance(config);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testCustomProxyWithContext_usingFactoryClassName() {
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig().setService(SERVICE_NAME_WITH_CONTEXT).setClassName(CustomProxyFactoryWithContext.class.getName());
        ClientConfig clientConfig = new ClientConfig().addProxyFactoryConfig(proxyFactoryConfig);
        this.testProxyCreation(SERVICE_NAME_WITH_CONTEXT, clientConfig);
    }

    @Test
    public void testCustomProxy_usingFactoryClassName() {
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig().setService(SERVICE_NAME).setClassName(CustomProxyFactory.class.getName());
        ClientConfig clientConfig = new ClientConfig().addProxyFactoryConfig(proxyFactoryConfig);
        this.testProxyCreation(SERVICE_NAME, clientConfig);
    }

    @Test
    public void testCustomProxyWithContext_usingFactoryImplementation() {
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig().setService(SERVICE_NAME_WITH_CONTEXT).setFactoryImpl((ClientProxyFactory)new CustomProxyFactoryWithContext());
        ClientConfig clientConfig = new ClientConfig().addProxyFactoryConfig(proxyFactoryConfig);
        this.testProxyCreation(SERVICE_NAME_WITH_CONTEXT, clientConfig);
    }

    @Test
    public void testCustomProxy_usingFactoryImplementation() {
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig().setService(SERVICE_NAME).setFactoryImpl((ClientProxyFactory)new CustomProxyFactory());
        ClientConfig clientConfig = new ClientConfig().addProxyFactoryConfig(proxyFactoryConfig);
        this.testProxyCreation(SERVICE_NAME, clientConfig);
    }

    @Test(expected=ExpectedError.class)
    public void testClientProxyFactoryWithContext_whenInitThrowsError() {
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig().setService(SERVICE_NAME_WITH_CONTEXT).setFactoryImpl((ClientProxyFactory)new ClientProxyFactoryWithContext(){

            public ClientProxy create(String id, ClientContext context) {
                return new ClientProxy(SERVICE_NAME_WITH_CONTEXT, id, context){

                    protected void onInitialize() {
                        super.onInitialize();
                        throw new ExpectedError();
                    }
                };
            }
        });
        ClientConfig clientConfig = new ClientConfig().addProxyFactoryConfig(proxyFactoryConfig);
        this.testProxyCreation(SERVICE_NAME_WITH_CONTEXT, clientConfig);
    }

    @Test(expected=ExpectedError.class)
    public void testClientProxyFactory_whenInitThrowsError() {
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig().setService(SERVICE_NAME).setFactoryImpl(new ClientProxyFactory(){

            public ClientProxy create(String id) {
                return new ClientProxy(SERVICE_NAME, id){

                    protected void onInitialize() {
                        super.onInitialize();
                        throw new ExpectedError();
                    }
                };
            }
        });
        ClientConfig clientConfig = new ClientConfig().addProxyFactoryConfig(proxyFactoryConfig);
        this.testProxyCreation(SERVICE_NAME, clientConfig);
    }

    private void testProxyCreation(String serviceName, ClientConfig clientConfig) {
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientInstanceImpl clientInstanceImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        this.context = clientInstanceImpl.getProxyManager().getContext();
        ClientProxy proxy = (ClientProxy)client.getDistributedObject(serviceName, "CustomClientProxy");
        Assert.assertEquals((Object)serviceName, (Object)proxy.getServiceName());
        Assert.assertEquals((Object)"CustomClientProxy", (Object)proxy.getName());
    }

    private static class ExpectedError
    extends Error {
        private ExpectedError() {
        }
    }

    private static class CustomClientProxy
    extends ClientProxy {
        protected CustomClientProxy(String serviceName, String objectName) {
            super(serviceName, objectName);
        }
    }

    private static class CustomProxyFactory
    implements ClientProxyFactory {
        private CustomProxyFactory() {
        }

        public ClientProxy create(String id) {
            return new CustomClientProxy(SERVICE_NAME, id);
        }
    }

    private static class CustomService
    implements RemoteService {
        private CustomService() {
        }

        public DistributedObject createDistributedObject(String objectName) {
            return new CustomClientProxy(SERVICE_NAME, objectName);
        }

        public void destroyDistributedObject(String objectName) {
        }
    }

    private static class CustomClientProxyWithContext
    extends ClientProxy {
        protected CustomClientProxyWithContext(String serviceName, String objectName, ClientContext context) {
            super(serviceName, objectName, context);
        }
    }

    private static class CustomProxyFactoryWithContext
    extends ClientProxyFactoryWithContext {
        private CustomProxyFactoryWithContext() {
        }

        public ClientProxy create(String id, ClientContext context) {
            return new CustomClientProxyWithContext(SERVICE_NAME_WITH_CONTEXT, id, context);
        }
    }

    private class CustomServiceWithContext
    implements RemoteService {
        private CustomServiceWithContext() {
        }

        public DistributedObject createDistributedObject(String objectName) {
            return new CustomClientProxyWithContext(SERVICE_NAME_WITH_CONTEXT, objectName, ProxyFactoryTest.this.context);
        }

        public void destroyDistributedObject(String objectName) {
        }
    }
}

