/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapGetCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.SmartClientInvocationService;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.instance.TestUtil;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.ThreadUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.LockSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientInvocationTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void executionCallback_TooLongThrowableStackTrace() throws InterruptedException {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(ClientInvocationTest.randomMapName());
        DummyEntryProcessor ep = new DummyEntryProcessor();
        int count = 100;
        FailureExecutionCallback[] callbacks = new FailureExecutionCallback[count];
        String key = ClientInvocationTest.randomString();
        for (int i = 0; i < count; ++i) {
            callbacks[i] = new FailureExecutionCallback();
            map.submitToKey((Object)key, (EntryProcessor)ep, (ExecutionCallback)callbacks[i]);
        }
        TestUtil.getNode((HazelcastInstance)server).getConnectionManager().shutdown();
        server.getLifecycleService().terminate();
        int callBackCount = 0;
        for (FailureExecutionCallback callback : callbacks) {
            ClientInvocationTest.assertOpenEventually((String)("Callback should be notified on time! callbackCount:" + ++callBackCount), (CountDownLatch)callback.latch);
            Throwable failure = callback.failure;
            if (failure == null) continue;
            int stackTraceLength = failure.getStackTrace().length;
            Assert.assertTrue((String)("Failure stack trace should not be too long! Current: " + stackTraceLength), (stackTraceLength < 50 ? 1 : 0) != 0);
            Throwable cause = failure.getCause();
            if (cause == null) continue;
            stackTraceLength = cause.getStackTrace().length;
            Assert.assertTrue((String)("Cause stack trace should not be too long! Current: " + stackTraceLength), (stackTraceLength < 50 ? 1 : 0) != 0);
        }
    }

    @Test
    public void executionCallback_FailOnShutdown() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        IMap map = client.getMap(ClientInvocationTest.randomName());
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED) {
                    disconnectedLatch.countDown();
                }
            }
        });
        server.shutdown();
        ClientInvocationTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        int n = 100;
        final CountDownLatch errorLatch = new CountDownLatch(n);
        for (int i = 0; i < n; ++i) {
            try {
                map.submitToKey((Object)ClientInvocationTest.randomString(), (EntryProcessor)new DummyEntryProcessor(), new ExecutionCallback(){

                    public void onResponse(Object response) {
                    }

                    public void onFailure(Throwable t) {
                        errorLatch.countDown();
                    }
                });
                continue;
            }
            catch (Exception e) {
                errorLatch.countDown();
            }
        }
        ClientInvocationTest.assertOpenEventually((String)"Not all of the requests failed", (CountDownLatch)errorLatch);
    }

    @Test(expected=TargetNotMemberException.class)
    public void invokeOnPartitionOwnerWhenPartitionTableNotUpdated() throws IOException, ExecutionException, InterruptedException {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(client);
        SmartClientInvocationService spyInvocationService = (SmartClientInvocationService)Mockito.spy((Object)((SmartClientInvocationService)clientInstanceImpl.getInvocationService()));
        Mockito.when((Object)spyInvocationService.isMember((Address)Matchers.any())).thenReturn((Object)false);
        SerializationService serializationService = clientInstanceImpl.getSerializationService();
        ClientMessage request = MapGetCodec.encodeRequest((String)"test", (Data)serializationService.toData((Object)"test"), (long)ThreadUtil.getThreadId());
        ClientInvocation invocation = new ClientInvocation(clientInstanceImpl, request, "map", 1);
        spyInvocationService.invokeOnPartitionOwner(invocation, 1);
    }

    private static class FailureExecutionCallback
    implements ExecutionCallback {
        final CountDownLatch latch = new CountDownLatch(1);
        volatile Throwable failure;

        private FailureExecutionCallback() {
        }

        public void onResponse(Object response) {
            this.latch.countDown();
        }

        public void onFailure(Throwable t) {
            this.failure = t;
            this.latch.countDown();
        }
    }

    private static class DummyEntryProcessor
    implements EntryProcessor {
        private DummyEntryProcessor() {
        }

        public Object process(Map.Entry entry) {
            LockSupport.parkNanos(10000L);
            return null;
        }

        public EntryBackupProcessor getBackupProcessor() {
            return null;
        }
    }
}

