/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ConflictingConfigTest {
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void init() {
        this.hazelcastFactory.newHazelcastInstance();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    @Test(expected=IllegalStateException.class)
    public void testAws_and_DiscoverySPIEnabled() {
        ClientConfig config = new ClientConfig();
        ClientAwsConfig awsConfig = new ClientAwsConfig();
        awsConfig.setEnabled(true);
        config.getNetworkConfig().setAwsConfig(awsConfig);
        config.setProperty(ClientProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        this.hazelcastFactory.newHazelcastClient(config);
    }

    @Test(expected=IllegalStateException.class)
    public void testHazelcastCloudViaProperty_and_DiscoverySPIEnabled() {
        ClientConfig config = new ClientConfig();
        config.setProperty(ClientProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        config.setProperty(ClientProperty.HAZELCAST_CLOUD_DISCOVERY_TOKEN.getName(), "TOKEN");
        this.hazelcastFactory.newHazelcastClient(config);
    }

    @Test(expected=IllegalStateException.class)
    public void testAws_and_HazelcastCloudViaPropertyEnabled() {
        ClientConfig config = new ClientConfig();
        config.setProperty(ClientProperty.HAZELCAST_CLOUD_DISCOVERY_TOKEN.getName(), "TOKEN");
        ClientAwsConfig awsConfig = new ClientAwsConfig();
        awsConfig.setEnabled(true);
        config.getNetworkConfig().setAwsConfig(awsConfig);
        this.hazelcastFactory.newHazelcastClient(config);
    }

    @Test(expected=IllegalStateException.class)
    public void testClusterMembersGiven_and_DiscoverySPIEnabled() {
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().addAddress(new String[]{"127.0.0.1"});
        config.setProperty(ClientProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        this.hazelcastFactory.newHazelcastClient(config);
    }

    @Test(expected=IllegalStateException.class)
    public void testHazelcastCloudViaProperty_and_ClusterMembersGiven() {
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().addAddress(new String[]{"127.0.0.1"});
        config.setProperty(ClientProperty.HAZELCAST_CLOUD_DISCOVERY_TOKEN.getName(), "TOKEN");
        this.hazelcastFactory.newHazelcastClient(config);
    }

    @Test(expected=IllegalStateException.class)
    public void testAws_and_ClusterMembersGiven() {
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().addAddress(new String[]{"127.0.0.1"});
        ClientAwsConfig awsConfig = new ClientAwsConfig();
        awsConfig.setEnabled(true);
        config.getNetworkConfig().setAwsConfig(awsConfig);
        this.hazelcastFactory.newHazelcastClient(config);
    }
}

