/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.starter;

import com.hazelcast.client.starter.HazelcastClientStarter;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.starter.HazelcastStarter;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class})
public class HazelcastClientStarterTest {
    @Test
    public void testClientLifecycle() throws InterruptedException {
        HazelcastInstance member = HazelcastStarter.newHazelcastInstance((String)"3.7");
        for (int i = 1; i < 6; ++i) {
            String version = "3.7." + i;
            System.out.println("Starting client " + version);
            HazelcastInstance instance = HazelcastClientStarter.newHazelcastClient(version, false);
            System.out.println("Stopping client " + version);
            instance.shutdown();
        }
        member.shutdown();
    }

    @Test
    public void testClientMap() throws InterruptedException {
        HazelcastInstance memberInstance = HazelcastStarter.newHazelcastInstance((String)"3.7");
        HazelcastInstance clientInstance = HazelcastClientStarter.newHazelcastClient("3.7.2", false);
        IMap clientMap = clientInstance.getMap("myMap");
        IMap memberMap = memberInstance.getMap("myMap");
        clientMap.put((Object)1, (Object)2);
        Assert.assertEquals((long)2L, (long)((Integer)memberMap.get((Object)1)).intValue());
        clientInstance.shutdown();
        memberInstance.shutdown();
    }

    @Test
    public void testAdvancedClientMap() throws InterruptedException {
        HazelcastInstance memberInstance = HazelcastStarter.newHazelcastInstance((String)"3.7");
        HazelcastInstance clientInstance = HazelcastClientStarter.newHazelcastClient("3.7.2", false);
        System.out.println("About to terminate the client");
        clientInstance.getLifecycleService().terminate();
        System.out.println("Client terminated");
        memberInstance.shutdown();
    }

    @Test
    public void testClientMap_async() throws InterruptedException, ExecutionException {
        HazelcastInstance memberInstance = HazelcastStarter.newHazelcastInstance((String)"3.7");
        HazelcastInstance clientInstance = HazelcastClientStarter.newHazelcastClient("3.7.2", false);
        IMap clientMap = clientInstance.getMap("myMap");
        clientMap.put((Object)0, (Object)1);
        ICompletableFuture async = clientMap.getAsync((Object)0);
        int value = (Integer)async.get();
        Assert.assertEquals((long)1L, (long)value);
        clientInstance.shutdown();
        memberInstance.shutdown();
    }
}

