/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={SlowTest.class})
public class ClientXATest {
    static final Random random = new Random(System.currentTimeMillis());
    static final ILogger logger = Logger.getLogger(ClientXATest.class);
    UserTransactionManager tm = null;

    public void cleanAtomikosLogs() {
        try {
            File[] tmLogs;
            File currentDir = new File(".");
            for (File tmLog : tmLogs = currentDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".epoch") || name.startsWith("tmlog");
                }
            })) {
                tmLog.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Before
    public void init() throws SystemException {
        this.cleanAtomikosLogs();
        this.tm = new UserTransactionManager();
        this.tm.setTransactionTimeout(60);
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @After
    public void cleanup() {
        this.tm.close();
        this.cleanAtomikosLogs();
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testRollbackOnTimeout() throws Exception {
        Hazelcast.newHazelcastInstance();
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        String name = HazelcastTestSupport.randomString();
        IQueue queue = client.getQueue(name);
        queue.offer((Object)HazelcastTestSupport.randomString());
        HazelcastXAResource xaResource = client.getXAResource();
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction transaction = this.tm.getTransaction();
        transaction.enlistResource((XAResource)xaResource);
        TransactionContext context = xaResource.getTransactionContext();
        try {
            context.getQueue(name).take();
            HazelcastTestSupport.sleepAtLeastSeconds((long)5L);
            this.tm.commit();
            Assert.fail();
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Queue size should be 1", (long)1L, (long)queue.size());
    }

    @Test
    public void testWhenLockedOutOfTransaction() throws Exception {
        Hazelcast.newHazelcastInstance();
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        IMap map = client.getMap("map");
        map.put((Object)"key", (Object)"value");
        HazelcastXAResource xaResource = client.getXAResource();
        this.tm.begin();
        Transaction transaction = this.tm.getTransaction();
        transaction.enlistResource((XAResource)xaResource);
        TransactionContext context = xaResource.getTransactionContext();
        TransactionalMap transactionalMap = context.getMap("map");
        if (map.tryLock((Object)"key")) {
            transactionalMap.remove((Object)"key");
        }
        this.tm.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollback() throws Exception {
        Hazelcast.newHazelcastInstance();
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        HazelcastXAResource xaResource = client.getXAResource();
        this.tm.begin();
        Transaction transaction = this.tm.getTransaction();
        transaction.enlistResource((XAResource)xaResource);
        TransactionContext context = xaResource.getTransactionContext();
        boolean error = false;
        try {
            try {
                TransactionalMap m = context.getMap("m");
                m.put((Object)"key", (Object)"value");
                throw new RuntimeException("Exception for rolling back");
            }
            catch (Exception e) {
                error = true;
                this.close(error, new XAResource[]{xaResource});
            }
        }
        catch (Throwable throwable) {
            this.close(error, new XAResource[]{xaResource});
            throw throwable;
        }
        Assert.assertNull((Object)client.getMap("m").get((Object)"key"));
    }

    @Test
    public void testRecovery() throws Exception {
        Xid[] recovered;
        HazelcastInstance instance = Hazelcast.newHazelcastInstance();
        Hazelcast.newHazelcastInstance();
        Hazelcast.newHazelcastInstance();
        HazelcastXAResource xaResource = instance.getXAResource();
        SerializableXID myXid = new SerializableXID(42, "globalTransactionId".getBytes(), "branchQualifier".getBytes());
        xaResource.start((Xid)myXid, 0);
        TransactionContext context1 = xaResource.getTransactionContext();
        TransactionalMap map = context1.getMap("map");
        map.put((Object)"key", (Object)"value");
        xaResource.prepare((Xid)myXid);
        instance.shutdown();
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        HazelcastXAResource clientXaResource = client.getXAResource();
        for (Xid xid : recovered = clientXaResource.recover(0)) {
            clientXaResource.commit(xid, false);
        }
        Assert.assertEquals((Object)"value", (Object)client.getMap("map").get((Object)"key"));
    }

    @Test
    public void testIsSame() throws Exception {
        HazelcastInstance instance1 = Hazelcast.newHazelcastInstance();
        HazelcastInstance instance2 = Hazelcast.newHazelcastInstance();
        HazelcastXAResource resource1 = instance1.getXAResource();
        HazelcastXAResource resource2 = instance2.getXAResource();
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        HazelcastXAResource clientResource = client.getXAResource();
        Assert.assertTrue((boolean)clientResource.isSameRM((XAResource)resource1));
        Assert.assertTrue((boolean)clientResource.isSameRM((XAResource)resource2));
    }

    @Test
    public void testParallel() throws Exception {
        Hazelcast.newHazelcastInstance();
        final HazelcastInstance client = HazelcastClient.newHazelcastClient();
        this.txn(client);
        int size = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        final CountDownLatch latch = new CountDownLatch(size);
        for (int i = 0; i < size; ++i) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClientXATest.this.txn(client);
                    }
                    catch (Exception e) {
                        logger.severe("Exception during txn", (Throwable)e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)latch, (long)20L);
        IMap m = client.getMap("m");
        for (int i = 0; i < 10; ++i) {
            Assert.assertFalse((boolean)m.isLocked((Object)i));
        }
    }

    @Test
    public void testSequential() throws Exception {
        Hazelcast.newHazelcastInstance();
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        int count = 100;
        for (int i = 0; i < count; ++i) {
            this.txn(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txn(HazelcastInstance instance) throws Exception {
        HazelcastXAResource xaResource = instance.getXAResource();
        this.tm.begin();
        Transaction transaction = this.tm.getTransaction();
        transaction.enlistResource((XAResource)xaResource);
        boolean error = false;
        try {
            TransactionContext context = xaResource.getTransactionContext();
            TransactionalMap m = context.getMap("m");
            m.put((Object)random.nextInt(10), (Object)"value");
        }
        catch (Exception e) {
            try {
                logger.severe("Exception during transaction", (Throwable)e);
                error = true;
            }
            catch (Throwable throwable) {
                this.close(error, new XAResource[]{xaResource});
                throw throwable;
            }
            this.close(error, new XAResource[]{xaResource});
        }
        this.close(error, new XAResource[]{xaResource});
    }

    private void close(boolean error, XAResource ... xaResource) throws Exception {
        int flag = 0x4000000;
        Transaction tx = this.tm.getTransaction();
        if (error) {
            flag = 0x20000000;
        }
        for (XAResource resource : xaResource) {
            tx.delistResource(resource, flag);
        }
        if (error) {
            this.tm.rollback();
        } else {
            this.tm.commit();
        }
    }
}

