/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMaxAllowedInvocationTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_withSyncOperation() {
        int MAX_ALLOWED = 10;
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.MAX_CONCURRENT_INVOCATIONS.getName(), String.valueOf(MAX_ALLOWED));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(ClientMaxAllowedInvocationTest.randomString());
        IExecutorService executorService = client.getExecutorService(ClientMaxAllowedInvocationTest.randomString());
        for (int i = 0; i < MAX_ALLOWED; ++i) {
            executorService.submit((Callable)new SleepyProcessor(Integer.MAX_VALUE));
        }
        map.get((Object)2);
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_withAsyncOperation() {
        int MAX_ALLOWED = 10;
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.MAX_CONCURRENT_INVOCATIONS.getName(), String.valueOf(MAX_ALLOWED));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(ClientMaxAllowedInvocationTest.randomString());
        IExecutorService executorService = client.getExecutorService(ClientMaxAllowedInvocationTest.randomString());
        for (int i = 0; i < MAX_ALLOWED; ++i) {
            executorService.submit((Callable)new SleepyProcessor(Integer.MAX_VALUE));
        }
        map.getAsync((Object)1);
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_andThenInternal() throws ExecutionException, InterruptedException {
        this.testMaxAllowed(new RegisterCallback(){

            @Override
            public void call(ClientDelegatingFuture future, ExecutionCallback callback) {
                future.andThenInternal(callback, false);
            }
        });
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_andThen() throws ExecutionException, InterruptedException {
        this.testMaxAllowed(new RegisterCallback(){

            @Override
            public void call(ClientDelegatingFuture future, ExecutionCallback callback) {
                future.andThen(callback);
            }
        });
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_andThenExecutor() throws ExecutionException, InterruptedException {
        this.testMaxAllowed(new RegisterCallback(){

            @Override
            public void call(ClientDelegatingFuture future, ExecutionCallback callback) {
                ExecutorService executor = Executors.newSingleThreadExecutor();
                future.andThen(callback, (Executor)executor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMaxAllowed(RegisterCallback registerCallbackCall) throws ExecutionException, InterruptedException {
        int MAX_ALLOWED = 10;
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.MAX_CONCURRENT_INVOCATIONS.getName(), String.valueOf(MAX_ALLOWED));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        String name = ClientMaxAllowedInvocationTest.randomString();
        IMap map = client.getMap(name);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        SleepyCallback sleepyCallback = new SleepyCallback(countDownLatch);
        try {
            IExecutorService executorService = client.getExecutorService(ClientMaxAllowedInvocationTest.randomString());
            for (int i = 0; i < MAX_ALLOWED - 1; ++i) {
                executorService.submit((Callable)new SleepyProcessor(Integer.MAX_VALUE));
            }
            ClientDelegatingFuture future = (ClientDelegatingFuture)executorService.submit((Callable)new SleepyProcessor(0L));
            registerCallbackCall.call(future, sleepyCallback);
            future.get();
            map.get((Object)1);
        }
        finally {
            countDownLatch.countDown();
        }
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_withWaitingCallbacks_andThenInternal() throws ExecutionException, InterruptedException {
        this.testMaxAllowed_withWaitingCallbacks(new RegisterCallback(){

            @Override
            public void call(ClientDelegatingFuture future, ExecutionCallback callback) {
                future.andThenInternal(callback, false);
            }
        });
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_withWaitingCallbacks_a_andThen() throws ExecutionException, InterruptedException {
        this.testMaxAllowed_withWaitingCallbacks(new RegisterCallback(){

            @Override
            public void call(ClientDelegatingFuture future, ExecutionCallback callback) {
                future.andThen(callback);
            }
        });
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_withWaitingCallbacks_andThenExecutor() throws ExecutionException, InterruptedException {
        this.testMaxAllowed_withWaitingCallbacks(new RegisterCallback(){

            @Override
            public void call(ClientDelegatingFuture future, ExecutionCallback callback) {
                ExecutorService executor = Executors.newSingleThreadExecutor();
                future.andThen(callback, (Executor)executor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMaxAllowed_withWaitingCallbacks(RegisterCallback registerCallbackCall) throws ExecutionException, InterruptedException {
        int MAX_ALLOWED = 10;
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.MAX_CONCURRENT_INVOCATIONS.getName(), String.valueOf(MAX_ALLOWED));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        String name = ClientMaxAllowedInvocationTest.randomString();
        IMap map = client.getMap(name);
        IExecutorService executorService = client.getExecutorService(ClientMaxAllowedInvocationTest.randomString());
        CountDownLatch countDownLatch = new CountDownLatch(1);
        SleepyCallback sleepyCallback = new SleepyCallback(countDownLatch);
        try {
            for (int i = 0; i < MAX_ALLOWED; ++i) {
                ClientDelegatingFuture future = (ClientDelegatingFuture)executorService.submit((Callable)new SleepyProcessor(0L));
                registerCallbackCall.call(future, sleepyCallback);
                future.get();
            }
            map.get((Object)1);
        }
        finally {
            countDownLatch.countDown();
        }
    }

    static class SleepyCallback
    implements ExecutionCallback<ClientMessage> {
        final ILogger logger = Logger.getLogger(this.getClass());
        final CountDownLatch countDownLatch;

        public SleepyCallback(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void onResponse(ClientMessage response) {
            try {
                this.logger.info("SleepyCallback onResponse entered. Will await for latch.");
                this.countDownLatch.await();
                this.logger.info("SleepyCallback onResponse latch wait finished.");
            }
            catch (InterruptedException e) {
                this.logger.info("SleepyCallback onResponse is interrupted.");
            }
        }

        public void onFailure(Throwable t) {
            this.logger.info("SleepyCallback onFailure is entered.");
        }
    }

    static interface RegisterCallback {
        public void call(ClientDelegatingFuture var1, ExecutionCallback var2);
    }

    static class SleepyProcessor
    implements Callable,
    Serializable {
        private long millis;

        SleepyProcessor(long millis) {
            this.millis = millis;
        }

        public Object call() throws Exception {
            ILogger logger = Logger.getLogger(this.getClass());
            try {
                logger.info("SleepyProcessor(" + this + ") sleeping for " + this.millis + " milliseconds");
                Thread.sleep(this.millis);
                logger.info("SleepyProcessor(" + this + ") woke up.");
            }
            catch (InterruptedException e) {
                logger.info("SleepyProcessor(" + this + ") is interrupted.");
            }
            return null;
        }
    }
}

