/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientOutBoundPortTest {
    @Before
    @After
    public void cleanUp() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void clientOutboundPortRangeTest() {
        Config config1 = new Config();
        config1.getGroupConfig().setName("client-out-test");
        Hazelcast.newHazelcastInstance((Config)config1);
        ClientConfig config2 = new ClientConfig();
        config2.getGroupConfig().setName("client-out-test");
        config2.getNetworkConfig().setOutboundPortDefinitions(Arrays.asList("34700", "34703-34705"));
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)config2);
        int port = ((Client)client.getLocalEndpoint()).getSocketAddress().getPort();
        HazelcastTestSupport.assertContains(Arrays.asList(34700, 34703, 34704, 34705), (Object)port);
    }
}

