/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapSizeCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.ExceptionUtil;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientProtocolTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupportedClientMessage() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        ClientMessage s = MapSizeCodec.encodeRequest((String)"mapName");
        int undefinedMessageType = 32766;
        s.setMessageType(undefinedMessageType);
        ClientInvocation invocation = new ClientInvocation(clientImpl, s, "mapName");
        try {
            invocation.invoke().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

