/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipAdapter;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.test.annotation.SlowTest;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientReconnectTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testClientReconnectOnClusterDown() throws Exception {
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final CountDownLatch connectedLatch = new CountDownLatch(2);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                connectedLatch.countDown();
            }
        });
        IMap m = client.getMap("default");
        h1.shutdown();
        this.hazelcastFactory.newHazelcastInstance();
        ClientReconnectTest.assertOpenEventually((CountDownLatch)connectedLatch);
        Assert.assertNull((Object)m.put((Object)"test", (Object)"test"));
        Assert.assertEquals((Object)"test", (Object)m.get((Object)"test"));
    }

    @Test
    public void testReconnectToNewInstanceAtSameAddress() throws InterruptedException {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        Address localAddress = instance.getCluster().getLocalMember().getAddress();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final CountDownLatch memberRemovedLatch = new CountDownLatch(1);
        client.getCluster().addMembershipListener((MembershipListener)new MembershipAdapter(){

            public void memberRemoved(MembershipEvent membershipEvent) {
                memberRemovedLatch.countDown();
            }
        });
        instance.shutdown();
        final HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance(localAddress);
        ClientReconnectTest.assertOpenEventually((CountDownLatch)memberRemovedLatch);
        ClientReconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                HazelcastTestSupport.assertClusterSize((int)1, (HazelcastInstance[])new HazelcastInstance[]{client});
                Iterator iterator = client.getCluster().getMembers().iterator();
                Member member = (Member)iterator.next();
                Assert.assertEquals((Object)instance2.getCluster().getLocalMember(), (Object)member);
            }
        });
    }

    @Test
    public void testClientShutdownIfReconnectionNotPossible() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(1);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final CountDownLatch shutdownLatch = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.SHUTDOWN) {
                    shutdownLatch.countDown();
                }
            }
        });
        server.shutdown();
        ClientReconnectTest.assertOpenEventually((CountDownLatch)shutdownLatch);
    }

    @Test(expected=HazelcastClientNotActiveException.class)
    public void testRequestShouldFailOnShutdown() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(1);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap test = client.getMap("test");
        test.put((Object)"key", (Object)"value");
        server.shutdown();
        test.get((Object)"key");
    }

    @Test(expected=HazelcastClientNotActiveException.class)
    public void testExceptionAfterClientShutdown() throws Exception {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap test = client.getMap("test");
        test.put((Object)"key", (Object)"value");
        client.shutdown();
        System.gc();
        test.get((Object)"key");
    }

    @Test
    public void testShutdownClient_whenThereIsNoCluster() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getConnectionStrategyConfig().setAsyncStart(true);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        client.shutdown();
    }

    @Test
    public void testClientConnected_withFirstAuthenticationTakingLong() throws InterruptedException {
        final AtomicInteger customCredentialsRunCount = new AtomicInteger();
        long customCredentialsSleepMillis = 30000L;
        SerializationConfig serializationConfig = new SerializationConfig();
        serializationConfig.addPortableFactory(1, new PortableFactory(){

            public Portable create(int classId) {
                return new CustomCredentials_takesLong(customCredentialsRunCount, 30000L);
            }
        });
        Config config = new Config();
        config.setSerializationConfig(serializationConfig);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setCredentials((Credentials)new CustomCredentials_takesLong("dev", "dev-pass"));
        clientConfig.setSerializationConfig(serializationConfig);
        this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @Test
    @Category(value={SlowTest.class})
    public void testEndpointCleanup_withFirstAuthenticationTakingLong() throws InterruptedException {
        int heartbeatTimeoutMillis;
        final AtomicInteger customCredentialsRunCount = new AtomicInteger();
        ClientConfig clientConfig = new ClientConfig();
        int authenticationTimeout = heartbeatTimeoutMillis = 5000;
        clientConfig.setProperty(ClientProperty.HEARTBEAT_TIMEOUT.getName(), String.valueOf(heartbeatTimeoutMillis));
        clientConfig.setProperty(ClientProperty.HEARTBEAT_INTERVAL.getName(), "1000");
        final long customCredentialsSleepMillis = authenticationTimeout * 2;
        SerializationConfig serializationConfig = new SerializationConfig();
        serializationConfig.addPortableFactory(1, new PortableFactory(){

            public Portable create(int classId) {
                return new CustomCredentials_takesLong(customCredentialsRunCount, customCredentialsSleepMillis);
            }
        });
        Config config = new Config();
        config.setSerializationConfig(serializationConfig);
        final HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance(config);
        clientConfig.setCredentials((Credentials)new CustomCredentials_takesLong("dev", "dev-pass"));
        clientConfig.setSerializationConfig(serializationConfig);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(1);
        clientConfig.getConnectionStrategyConfig().setAsyncStart(true);
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        Thread.sleep(customCredentialsSleepMillis + 3000L);
        ClientReconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                int size = instance.getClientService().getConnectedClients().size();
                Assert.assertEquals((long)0L, (long)size);
            }
        });
    }

    @Test
    public void testClientConnected_withFirstAuthenticationRetried() throws InterruptedException {
        SerializationConfig serializationConfig = new SerializationConfig();
        serializationConfig.addPortableFactory(1, new PortableFactory(){

            public Portable create(int classId) {
                return new CustomCredentials_retried();
            }
        });
        Config config = new Config();
        config.setSerializationConfig(serializationConfig);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionTimeout(30000);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(1);
        clientConfig.setCredentials((Credentials)new CustomCredentials_retried("dev", "dev-pass"));
        clientConfig.setSerializationConfig(serializationConfig);
        this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    public static class CustomCredentials_retried
    extends CustomCredentials {
        private static AtomicInteger count = new AtomicInteger();

        public CustomCredentials_retried() {
        }

        CustomCredentials_retried(String username, String password) {
            super(username, password);
        }

        public String getPassword() {
            if (count.incrementAndGet() == 1) {
                throw new HazelcastInstanceNotActiveException();
            }
            return super.getPassword();
        }
    }

    public static class CustomCredentials_takesLong
    extends CustomCredentials {
        private AtomicInteger count;
        private long sleepMillis;

        CustomCredentials_takesLong(AtomicInteger count, long sleepMillis) {
            this.count = count;
            this.sleepMillis = sleepMillis;
        }

        CustomCredentials_takesLong(String username, String password) {
            super(username, password);
        }

        protected void readPortableInternal(PortableReader reader) throws IOException {
            if (this.count.incrementAndGet() == 1) {
                try {
                    Thread.sleep(this.sleepMillis);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            super.readPortableInternal(reader);
        }
    }

    public static abstract class CustomCredentials
    extends UsernamePasswordCredentials {
        public CustomCredentials() {
        }

        CustomCredentials(String username, String password) {
            super(username, password);
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 1;
        }
    }
}

