/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.impl.operations.GetConnectedClientsOperation;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.ClientType;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.TestUtil;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ConnectedClientOperationTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.factory.terminateAll();
    }

    @Test
    public void testNumberOfConnectedClients() throws Exception {
        HazelcastInstance h1 = this.factory.newHazelcastInstance();
        HazelcastInstance h2 = this.factory.newHazelcastInstance();
        ConnectedClientOperationTest.assertClusterSize((int)2, (HazelcastInstance[])new HazelcastInstance[]{h1, h2});
        int numberOfClients = 6;
        for (int i = 0; i < numberOfClients; ++i) {
            this.factory.newHazelcastClient();
        }
        Node node = TestUtil.getNode((HazelcastInstance)h1);
        Map clientStats = node.clientEngine.getConnectedClientStats();
        Assert.assertEquals((long)numberOfClients, (long)((Integer)clientStats.get(ClientType.JAVA)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)clientStats.get(ClientType.CPP)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)clientStats.get(ClientType.CSHARP)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)clientStats.get(ClientType.NODEJS)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)clientStats.get(ClientType.PYTHON)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)clientStats.get(ClientType.GO)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)clientStats.get(ClientType.OTHER)).intValue());
    }

    @Test
    public void testGetConnectedClientsOperation_WhenZeroClientConnects() throws Exception {
        HazelcastInstance instance = this.factory.newHazelcastInstance();
        Node node = TestUtil.getNode((HazelcastInstance)instance);
        GetConnectedClientsOperation operation = new GetConnectedClientsOperation();
        InternalOperationService operationService = node.nodeEngine.getOperationService();
        InternalCompletableFuture future = operationService.invokeOnTarget("hz:core:clientEngine", (Operation)operation, node.address);
        Map clients = (Map)future.get();
        Assert.assertEquals((long)0L, (long)clients.size());
    }

    @Test
    public void testGetConnectedClientsOperation_WhenMoreThanZeroClientConnects() throws Exception {
        HazelcastInstance instance = this.factory.newHazelcastInstance();
        this.factory.newHazelcastClient();
        this.factory.newHazelcastClient();
        Node node = TestUtil.getNode((HazelcastInstance)instance);
        GetConnectedClientsOperation operation = new GetConnectedClientsOperation();
        InternalOperationService operationService = node.nodeEngine.getOperationService();
        InternalCompletableFuture future = operationService.invokeOnTarget("hz:core:clientEngine", (Operation)operation, node.address);
        Map clients = (Map)future.get();
        Assert.assertEquals((long)2L, (long)clients.size());
    }
}

