/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.Arrays;
import java.util.Iterator;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class AbstractClientCachePartitionIteratorTest
extends HazelcastTestSupport {
    @Parameterized.Parameter
    public boolean prefetchValues;
    protected TestHazelcastFactory factory;
    protected CachingProvider cachingProvider;
    protected HazelcastInstance server;

    @Parameterized.Parameters(name="prefetchValues:{0}")
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({Boolean.TRUE}, {Boolean.FALSE});
    }

    @After
    public void teardown() {
        this.factory.terminateAll();
    }

    @Test
    public void test_HasNext_Returns_False_On_EmptyPartition() throws Exception {
        ICacheInternal cache = this.getCacheProxy();
        Iterator iterator = cache.iterator(10, 1, this.prefetchValues);
        junit.framework.Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void test_HasNext_Returns_True_On_NonEmptyPartition() throws Exception {
        ICacheInternal cache = this.getCacheProxy();
        String key = AbstractClientCachePartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
        String value = AbstractClientCachePartitionIteratorTest.randomString();
        cache.put((Object)key, (Object)value);
        Iterator iterator = cache.iterator(10, 1, this.prefetchValues);
        junit.framework.Assert.assertTrue((boolean)iterator.hasNext());
    }

    @Test
    public void test_Next_Returns_Value_On_NonEmptyPartition() throws Exception {
        ICacheInternal cache = this.getCacheProxy();
        String key = AbstractClientCachePartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
        String value = AbstractClientCachePartitionIteratorTest.randomString();
        cache.put((Object)key, (Object)value);
        Iterator iterator = cache.iterator(10, 1, this.prefetchValues);
        Cache.Entry entry = (Cache.Entry)iterator.next();
        Assert.assertEquals((Object)value, (Object)entry.getValue());
    }

    @Test
    public void test_Next_Returns_Value_On_NonEmptyPartition_and_HasNext_Returns_False_when_Item_Consumed() throws Exception {
        ICacheInternal cache = this.getCacheProxy();
        String key = AbstractClientCachePartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
        String value = AbstractClientCachePartitionIteratorTest.randomString();
        cache.put((Object)key, (Object)value);
        Iterator iterator = cache.iterator(10, 1, this.prefetchValues);
        Cache.Entry entry = (Cache.Entry)iterator.next();
        Assert.assertEquals((Object)value, (Object)entry.getValue());
        boolean hasNext = iterator.hasNext();
        junit.framework.Assert.assertFalse((boolean)hasNext);
    }

    @Test
    public void test_Next_Returns_Values_When_FetchSizeExceeds_On_NonEmptyPartition() throws Exception {
        ICacheInternal cache = this.getCacheProxy();
        String value = AbstractClientCachePartitionIteratorTest.randomString();
        int count = 1000;
        for (int i = 0; i < count; ++i) {
            String key = AbstractClientCachePartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)42);
            cache.put((Object)key, (Object)value);
        }
        Iterator iterator = cache.iterator(10, 42, this.prefetchValues);
        for (int i = 0; i < count; ++i) {
            Cache.Entry entry = (Cache.Entry)iterator.next();
            Assert.assertEquals((Object)value, (Object)entry.getValue());
        }
    }

    private <K, V> ICacheInternal<K, V> getCacheProxy() {
        String cacheName = AbstractClientCachePartitionIteratorTest.randomString();
        CacheManager cacheManager = this.cachingProvider.getCacheManager();
        CacheConfig config = new CacheConfig();
        config.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(10000000);
        return (ICacheInternal)cacheManager.createCache(cacheName, (Configuration)config);
    }
}

