/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.cache.CacheCreationTest;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.SlowTest;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={SlowTest.class})
public class ClientCacheCreationTest
extends CacheCreationTest {
    protected CachingProvider createCachingProvider(Config hzConfig) {
        Hazelcast.newHazelcastInstance((Config)hzConfig);
        ClientConfig clientConfig = null;
        if (hzConfig != null) {
            clientConfig = new ClientConfig();
            clientConfig.getGroupConfig().setName(hzConfig.getGroupConfig().getName());
            clientConfig.getGroupConfig().setPassword(hzConfig.getGroupConfig().getPassword());
            clientConfig.getNetworkConfig().setAddresses(Collections.singletonList("127.0.0.1"));
        }
        return HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)HazelcastClient.newHazelcastClient(clientConfig));
    }

    @Test(expected=OperationTimeoutException.class)
    public void createSingleCache_whenMemberDown_throwsOperationTimeoutException() {
        HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "2");
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        HazelcastClientCachingProvider cachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = cachingProvider.getCacheManager();
        hazelcastInstance.shutdown();
        MutableConfiguration configuration = new MutableConfiguration();
        cacheManager.createCache("xmlCache", (Configuration)configuration);
    }

    @Test
    public void createSingleCache_whenMemberBounce() throws InterruptedException {
        HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        HazelcastClientCachingProvider cachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        final CacheManager cacheManager = cachingProvider.getCacheManager();
        hazelcastInstance.shutdown();
        final CountDownLatch cacheCreated = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MutableConfiguration configuration = new MutableConfiguration();
                cacheManager.createCache("xmlCache", (Configuration)configuration);
                cacheCreated.countDown();
            }
        }).start();
        Thread.sleep(2000L);
        Hazelcast.newHazelcastInstance();
        ClientCacheCreationTest.assertOpenEventually((CountDownLatch)cacheCreated);
    }

    @Test
    @Ignore(value="Only applicable for member-side HazelcastInstance")
    public void createInvalidCache_fromDeclarativeConfig_throwsException_fromHazelcastInstanceCreation() {
    }
}

