/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheNearCacheSmokeTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME = "test";
    private static final int CLUSTER_SIZE = 3;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private final ClientConfig clientConfig = new ClientConfig();
    private final CacheConfig cacheConfig = new CacheConfig();
    private Cache<Integer, Integer> serverCache1;
    private Cache<Integer, Integer> clientCache;
    HazelcastInstance server1;

    @Before
    public void setUp() {
        NearCacheConfig nearCacheConfig = this.newNearCacheConfig();
        nearCacheConfig.setInvalidateOnChange(true);
        this.clientConfig.addNearCacheConfig(nearCacheConfig);
        this.cacheConfig.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        Config config = this.getConfig();
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "false");
        this.server1 = this.factory.newHazelcastInstance(config);
        HazelcastInstance server2 = this.factory.newHazelcastInstance(config);
        HazelcastInstance server3 = this.factory.newHazelcastInstance(config);
        ClientCacheNearCacheSmokeTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{this.server1, server2, server3});
        this.serverCache1 = this.createServerCache(this.server1);
    }

    protected NearCacheConfig newNearCacheConfig() {
        return new NearCacheConfig(CACHE_NAME);
    }

    private Cache createServerCache(HazelcastInstance server1) {
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)server1);
        CacheManager serverCacheManager = provider.getCacheManager();
        return serverCacheManager.createCache(CACHE_NAME, (Configuration)this.cacheConfig);
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void smoke_near_cache_population() {
        int i;
        int cacheSize = 1000;
        for (i = 0; i < cacheSize; ++i) {
            this.serverCache1.put((Object)i, (Object)i);
        }
        this.clientCache = this.createCacheFromNewClient();
        for (i = 0; i < cacheSize; ++i) {
            Assert.assertNotNull((Object)this.clientCache.get((Object)i));
        }
        Assert.assertEquals((long)cacheSize, (long)((NearCachedClientCacheProxy)this.clientCache).getNearCache().size());
    }

    private Cache createCacheFromNewClient() {
        HazelcastClientProxy client = (HazelcastClientProxy)this.factory.newHazelcastClient(this.clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = clientCachingProvider.getCacheManager();
        return cacheManager.createCache(CACHE_NAME, (Configuration)this.cacheConfig);
    }
}

