/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.stats;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.ICache;
import com.hazelcast.cache.stats.CacheStatsTest;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import javax.cache.spi.CachingProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheStatsTest
extends CacheStatsTest {
    @Parameterized.Parameter
    public boolean nearCacheEnabled;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final TestHazelcastFactory instanceFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @Parameterized.Parameters(name="nearCached:{0}")
    public static Collection<Object> parameters() {
        return Arrays.asList(Boolean.TRUE, Boolean.FALSE);
    }

    protected void onSetup() {
        super.onSetup();
        this.getHazelcastInstance();
        ClientConfig clientConfig = this.createClientConfig();
        this.client = this.instanceFactory.newHazelcastClient(clientConfig);
    }

    protected void onTearDown() {
        super.onTearDown();
        this.instanceFactory.shutdownAll();
    }

    protected HazelcastInstance getHazelcastInstance() {
        return this.instanceFactory.newHazelcastInstance(this.createConfig());
    }

    protected CachingProvider getCachingProvider() {
        return HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)this.client);
    }

    protected ClientConfig createClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        if (this.nearCacheEnabled) {
            clientConfig.addNearCacheConfig(new NearCacheConfig("*"));
        }
        return clientConfig;
    }

    @Test
    public void testOwnedEntryCountWhenThereIsNoBackup() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.testOwnedEntryCountWhenThereIsNoBackup();
    }

    @Test
    public void testOwnedEntryCountWhenThereAreBackupsOnStaticCluster() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.testOwnedEntryCountWhenThereAreBackupsOnStaticCluster();
    }

    @Test
    public void testOwnedEntryCountWhenThereAreBackupsOnDynamicCluster() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.testOwnedEntryCountWhenThereAreBackupsOnDynamicCluster();
    }

    @Test
    public void testExpirations() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.testExpirations();
    }

    @Test
    public void testEvictions() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.testEvictions();
    }

    @Test
    public void testNearCacheStats_availableWhenEnabled() {
        if (this.nearCacheEnabled) {
            this.testNearCacheStats_whenNearCacheEnabled();
        } else {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.testNearCacheStats_whenNearCacheDisabled();
        }
    }

    private void testNearCacheStats_whenNearCacheDisabled() {
        ICache cache = this.createCache();
        CacheStatistics stats = cache.getLocalCacheStatistics();
        stats.getNearCacheStatistics();
    }

    private void testNearCacheStats_whenNearCacheEnabled() {
        String cacheName = ClientCacheStatsTest.randomName();
        CacheConfig cacheConfig = this.createCacheConfig();
        cacheConfig.setName(cacheName);
        ClientConfig clientConfig = ((HazelcastClientProxy)this.client).getClientConfig();
        clientConfig.addNearCacheConfig(new NearCacheConfig().setName(cacheName));
        ICache cache = this.createCache(cacheName, cacheConfig);
        CacheStatistics stats = cache.getLocalCacheStatistics();
        Assert.assertNotNull((Object)stats.getNearCacheStatistics());
    }
}

