/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.collections;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientListTest
extends HazelcastTestSupport {
    private TestHazelcastFactory hazelcastFactory;
    private IList<String> list;

    @Before
    public void setup() throws IOException {
        this.hazelcastFactory = new TestHazelcastFactory();
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        this.list = client.getList(ClientListTest.randomString());
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    @Test
    public void testAddAll() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("item1");
        l.add("item2");
        Assert.assertTrue((boolean)this.list.addAll(l));
        Assert.assertEquals((long)2L, (long)this.list.size());
        Assert.assertTrue((boolean)this.list.addAll(1, l));
        Assert.assertEquals((long)4L, (long)this.list.size());
        Assert.assertEquals((Object)"item1", (Object)this.list.get(0));
        Assert.assertEquals((Object)"item1", (Object)this.list.get(1));
        Assert.assertEquals((Object)"item2", (Object)this.list.get(2));
        Assert.assertEquals((Object)"item2", (Object)this.list.get(3));
    }

    @Test
    public void testAddSetRemove() {
        Assert.assertTrue((boolean)this.list.add((Object)"item1"));
        Assert.assertTrue((boolean)this.list.add((Object)"item2"));
        this.list.add(0, (Object)"item3");
        Assert.assertEquals((long)3L, (long)this.list.size());
        String element = (String)this.list.set(2, (Object)"item4");
        Assert.assertEquals((Object)"item2", (Object)element);
        Assert.assertEquals((long)3L, (long)this.list.size());
        Assert.assertEquals((Object)"item3", (Object)this.list.get(0));
        Assert.assertEquals((Object)"item1", (Object)this.list.get(1));
        Assert.assertEquals((Object)"item4", (Object)this.list.get(2));
        Assert.assertFalse((boolean)this.list.remove((Object)"item2"));
        Assert.assertTrue((boolean)this.list.remove((Object)"item3"));
        element = (String)this.list.remove(1);
        Assert.assertEquals((Object)"item4", (Object)element);
        Assert.assertEquals((long)1L, (long)this.list.size());
        Assert.assertEquals((Object)"item1", (Object)this.list.get(0));
    }

    @Test
    public void testIndexOf() {
        Assert.assertTrue((boolean)this.list.add((Object)"item1"));
        Assert.assertTrue((boolean)this.list.add((Object)"item2"));
        Assert.assertTrue((boolean)this.list.add((Object)"item1"));
        Assert.assertTrue((boolean)this.list.add((Object)"item4"));
        Assert.assertEquals((long)-1L, (long)this.list.indexOf((Object)"item5"));
        Assert.assertEquals((long)0L, (long)this.list.indexOf((Object)"item1"));
        Assert.assertEquals((long)-1L, (long)this.list.lastIndexOf((Object)"item6"));
        Assert.assertEquals((long)2L, (long)this.list.lastIndexOf((Object)"item1"));
    }

    @Test
    public void testIterator() {
        Assert.assertTrue((boolean)this.list.add((Object)"item1"));
        Assert.assertTrue((boolean)this.list.add((Object)"item2"));
        Assert.assertTrue((boolean)this.list.add((Object)"item1"));
        Assert.assertTrue((boolean)this.list.add((Object)"item4"));
        Iterator iter = this.list.iterator();
        Assert.assertEquals((Object)"item1", iter.next());
        Assert.assertEquals((Object)"item2", iter.next());
        Assert.assertEquals((Object)"item1", iter.next());
        Assert.assertEquals((Object)"item4", iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        ListIterator listIterator = this.list.listIterator(2);
        Assert.assertEquals((Object)"item1", listIterator.next());
        Assert.assertEquals((Object)"item4", listIterator.next());
        Assert.assertFalse((boolean)listIterator.hasNext());
        List l = this.list.subList(1, 3);
        Assert.assertEquals((long)2L, (long)l.size());
        Assert.assertEquals((Object)"item2", l.get(0));
        Assert.assertEquals((Object)"item1", l.get(1));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)this.list.add((Object)"item1"));
        Assert.assertTrue((boolean)this.list.add((Object)"item2"));
        Assert.assertTrue((boolean)this.list.add((Object)"item1"));
        Assert.assertTrue((boolean)this.list.add((Object)"item4"));
        ClientListTest.assertNotContains(this.list, (Object)"item3");
        ClientListTest.assertContains(this.list, (Object)"item2");
        ArrayList<String> l = new ArrayList<String>();
        l.add("item4");
        l.add("item3");
        ClientListTest.assertNotContainsAll(this.list, l);
        Assert.assertTrue((boolean)this.list.add((Object)"item3"));
        ClientListTest.assertContainsAll(this.list, l);
    }

    @Test
    public void removeRetainAll() {
        Assert.assertTrue((boolean)this.list.add((Object)"item1"));
        Assert.assertTrue((boolean)this.list.add((Object)"item2"));
        Assert.assertTrue((boolean)this.list.add((Object)"item1"));
        Assert.assertTrue((boolean)this.list.add((Object)"item4"));
        ArrayList<String> l = new ArrayList<String>();
        l.add("item4");
        l.add("item3");
        Assert.assertTrue((boolean)this.list.removeAll(l));
        Assert.assertEquals((long)3L, (long)this.list.size());
        Assert.assertFalse((boolean)this.list.removeAll(l));
        Assert.assertEquals((long)3L, (long)this.list.size());
        l.clear();
        l.add("item1");
        l.add("item2");
        Assert.assertFalse((boolean)this.list.retainAll(l));
        Assert.assertEquals((long)3L, (long)this.list.size());
        l.clear();
        Assert.assertTrue((boolean)this.list.retainAll(l));
        Assert.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testListener() throws Exception {
        final CountDownLatch latch = new CountDownLatch(6);
        ItemListener<String> listener = new ItemListener<String>(){

            public void itemAdded(ItemEvent<String> itemEvent) {
                latch.countDown();
            }

            public void itemRemoved(ItemEvent<String> item) {
            }
        };
        String registrationId = this.list.addItemListener((ItemListener)listener, true);
        new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 5; ++i) {
                    ClientListTest.this.list.add((Object)("item" + i));
                }
                ClientListTest.this.list.add((Object)"done");
            }
        }.start();
        Assert.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
        this.list.removeItemListener(registrationId);
    }

    @Test
    public void testIsEmpty_whenEmpty() {
        Assert.assertTrue((boolean)this.list.isEmpty());
        Assert.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testIsEmpty_whenNotEmpty() {
        this.list.add((Object)"item");
        Assert.assertFalse((boolean)this.list.isEmpty());
        Assert.assertEquals((long)1L, (long)this.list.size());
    }
}

