/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientClasspathXmlConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class InvalidConfigurationClientTest {
    @Test
    public void testWhenXmlValid() {
        String xml = this.getDraftXml();
        this.buildConfig(xml);
    }

    @Test
    public void testWhenValid_SmartRoutingEnabled() {
        this.buildConfig("smart-routing-enabled", "false");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testWhenInValid_SmartRoutingEnabled() {
        this.buildConfig("smart-routing-enabled", "false1");
    }

    @Test
    public void testWhenValid_RedoOperationEnabled() {
        this.buildConfig("redo-operation-enabled", "true");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testWhenInValid_RedoOperationEnabled() {
        this.buildConfig("redo-operation-enabled", "tr1ue");
    }

    @Test
    public void testWhenValid_SocketInterceptorEnabled() {
        this.buildConfig("socket-interceptor-enabled", "true");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testWhenInvalid_SocketInterceptorEnabled() {
        this.buildConfig("socket-interceptor-enabled", "ttrue");
    }

    @Test
    public void testWhenValid_AwsEnabled() {
        this.buildConfig("aws-enabled", "true");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testWhenInvalid_AwsEnabled() {
        this.buildConfig("aws-enabled", "falsee");
    }

    @Test
    public void testWhenValid_InsideAwsEnabled() {
        this.buildConfig("inside-aws-enabled", "true");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testWhenIamRoleEnabled_InsideAwsDisabled() {
        this.buildConfig("inside-aws-enabled", "false");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testWhenInvalid_InsideAwsEnabled() {
        this.buildConfig("inside-aws-enabled", "tRue");
    }

    @Test
    public void WhenValid_ExecutorPoolSize() {
        this.buildConfig("executor-pool-size", "17");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void WhenInvalid_ExecutorPoolSize() {
        this.buildConfig("executor-pool-size", "0");
    }

    @Test
    public void WhenValid_CredentialsClassName() {
        this.buildConfig("credentials-class-name", "com.hazelcast.client.config.Credentials");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void WhenInvalid_CredentialsClassName() {
        this.buildConfig("credentials-class-name", " com.hazelcast.client.config.Credentials");
    }

    @Test
    public void WhenValid_ListenerClassName() {
        this.buildConfig("listener-class-name", "com.hazelcast.client.config.Listener");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void WhenInvalid_ListenerClassName() {
        this.buildConfig("listener-class-name", " com.hazelcast.client.config.Listener");
    }

    @Test
    public void WhenValid_NativeByteOrder() {
        this.buildConfig("use-native-byte-order", "true");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void WhenInValid_NativeByteOrder() {
        this.buildConfig("use-native-byte-order", "truue");
    }

    @Test
    public void WhenValid_LoadBalancerType() {
        this.buildConfig("load-balancer-type", "round-robin");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void WhenInvalid_LoadBalancerType() {
        this.buildConfig("load-balancer-type", "roundrobin");
    }

    @Test
    public void WhenValid_EvictionPolicy() {
        this.buildConfig("eviction-policy", "LRU");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void WhenInvalid_EvictionPolicy() {
        this.buildConfig("eviction-policy", "none");
    }

    @Test
    public void WhenValid_NearCacheInMemoryFormat() {
        this.buildConfig("near-cache-in-memory-format", "OBJECT");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void WhenInvalid_NearCacheInMemoryFormat() {
        this.buildConfig("near-cache-in-memory-format", "binaryyy");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testWhenInvalid_NearCacheTTLSeconds() {
        this.buildConfig("near-cache-time-to-live-seconds", "-1");
    }

    @Test
    public void testWhenValid_NearCacheTTLSeconds() {
        this.buildConfig("near-cache-time-to-live-seconds", "100");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testWhenInvalid_NearCacheMaxIdleSeconds() {
        this.buildConfig("near-cache-max-idle-seconds", "-1");
    }

    @Test
    public void testWhenValid_NearCacheMaxIdleSeconds() {
        this.buildConfig("near-cache-max-idle-seconds", "100");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testWhenInvalid_NearCacheEvictionSize() {
        this.buildConfig("near-cache-eviction-size", "-100");
    }

    @Test
    public void testWhenValid_NearCacheEvictionSize() {
        this.buildConfig("near-cache-eviction-size", "100");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClassPathConfigWhenNullClassLoader() {
        new ClientClasspathXmlConfig(null, "my_config.xml", System.getProperties());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClassPathConfigWhenNullProperties() {
        new ClientClasspathXmlConfig(Thread.currentThread().getContextClassLoader(), "my_config.xml", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClassPathConfigWhenNullResource() {
        new ClientClasspathXmlConfig(Thread.currentThread().getContextClassLoader(), null, System.getProperties());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClassPathConfigWhenNonExistentConfig() {
        new ClientClasspathXmlConfig(Thread.currentThread().getContextClassLoader(), "non-existent-client-config.xml", System.getProperties());
    }

    @Test(expected=InvalidConfigurationException.class)
    public void WhenDuplicateTagsAdded() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n  <network>\n    <cluster-members>\n      <address>127.0.0.1</address>\n    </cluster-members>\n  </network>\n  <network>\n    <cluster-members>\n      <address>127.0.0.1</address>\n    </cluster-members>\n  </network>\n</hazelcast-client>\n";
        this.buildConfig(xml);
    }

    String getDraftXml() {
        return "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n  <network>\n    <cluster-members>\n      <address>127.0.0.1</address>\n    </cluster-members>\n    <smart-routing>${smart-routing-enabled}</smart-routing>\n    <redo-operation>${redo-operation-enabled}</redo-operation>\n    <socket-interceptor enabled=\"${socket-interceptor-enabled}\">\n      <class-name>com.hazelcast.examples.MySocketInterceptor</class-name>\n    </socket-interceptor>\n    <aws enabled=\"${aws-enabled}\" connection-timeout-seconds=\"${aws-timeout}\">\n      <inside-aws>${inside-aws-enabled}</inside-aws>\n      <access-key>TEST_ACCESS_KEY</access-key>\n      <secret-key>TEST_SECRET_KEY</secret-key>\n      <iam-role>TEST_IAM_ROLE</iam-role>\n    </aws>\n  </network>\n  <executor-pool-size>${executor-pool-size}</executor-pool-size>\n  <security>\n    <credentials>${credentials-class-name}</credentials>\n  </security>\n  <listeners>\n    <listener>${listener-class-name}</listener>\n  </listeners>\n  <serialization>\n    <portable-version>3</portable-version>\n    <use-native-byte-order>${use-native-byte-order}</use-native-byte-order>\n    <byte-order>${byte-order}</byte-order>\n    <enable-compression>${enable-compression}</enable-compression>\n    <enable-shared-object>${enable-shared-object}</enable-shared-object>\n    <allow-unsafe>${allow-unsafe}</allow-unsafe>\n  </serialization>\n  <load-balancer type=\"${load-balancer-type}\"/>\n  <near-cache name=\"testNearCache\">\n    <time-to-live-seconds>${near-cache-time-to-live-seconds}</time-to-live-seconds>\n    <max-idle-seconds>${near-cache-max-idle-seconds}</max-idle-seconds>\n    <invalidate-on-change>${near-cache-invalidate-on-change}</invalidate-on-change>\n    <in-memory-format>${near-cache-in-memory-format}</in-memory-format>\n    <cache-local-entries>${near-cache-cache-local-entries}</cache-local-entries>\n    <eviction-policy>${eviction-policy}</eviction-policy>\n    <eviction size=\"${near-cache-eviction-size}\"       max-size-policy=\"${near-cache-eviction-max-size-policy}\"       eviction-policy=\"${near-cache-eviction-policy}\"/>\n  </near-cache></hazelcast-client>\n";
    }

    Properties getDraftProperties() {
        Properties properties = new Properties();
        properties.setProperty("smart-routing-enabled", "true");
        properties.setProperty("redo-operation-enabled", "true");
        properties.setProperty("socket-interceptor-enabled", "true");
        properties.setProperty("aws-enabled", "true");
        properties.setProperty("aws-timeout", "10");
        properties.setProperty("inside-aws-enabled", "true");
        properties.setProperty("executor-pool-size", "40");
        properties.setProperty("credentials-class-name", "com.hazelcast.security.UsernamePasswordCredentials");
        properties.setProperty("listener-class-name", "com.hazelcast.examples.MembershipListener");
        properties.setProperty("use-native-byte-order", "true");
        properties.setProperty("byte-order", "BIG_ENDIAN");
        properties.setProperty("enable-compression", "true");
        properties.setProperty("enable-shared-object", "true");
        properties.setProperty("allow-unsafe", "true");
        properties.setProperty("load-balancer-type", "random");
        properties.setProperty("eviction-policy", "LFU");
        properties.setProperty("in-memory-format", "OBJECT");
        properties.setProperty("near-cache-time-to-live-seconds", "10000");
        properties.setProperty("near-cache-max-idle-seconds", "5000");
        properties.setProperty("near-cache-invalidate-on-change", "true");
        properties.setProperty("near-cache-in-memory-format", "BINARY");
        properties.setProperty("near-cache-cache-local-entries", "true");
        properties.setProperty("near-cache-eviction-size", "100");
        properties.setProperty("near-cache-eviction-max-size-policy", "ENTRY_COUNT");
        properties.setProperty("near-cache-eviction-policy", "LRU");
        return properties;
    }

    ClientConfig buildConfig(String xml) {
        return this.buildConfig(xml, this.getDraftProperties());
    }

    ClientConfig buildConfig(String propertyKey, String propertyValue) {
        String xml = this.getDraftXml();
        Properties properties = this.getDraftProperties();
        properties.setProperty(propertyKey, propertyValue);
        return this.buildConfig(xml, properties);
    }

    ClientConfig buildConfig(String xml, Properties properties) {
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder((InputStream)bis);
        configBuilder.setProperties(properties);
        return configBuilder.build();
    }
}

